/* PixArt Optical Finger Navigation, OFN, sensor driver.
 * By PixArt Imaging Inc.
 * Primary Engineer: Hill Chen (PixArt USA)
 *
 * License: Apache-2.0; http://www.apache.org/licenses/LICENSE-2.0
 */

#pragma once
#include "mbed.h"

class Pixart_ComPort
{
public:
    virtual void writeRegister(uint8_t addr, uint8_t data) = 0;
    virtual uint8_t readRegister(uint8_t addr) = 0;
};


class Pixart_I2cComPort: public Pixart_ComPort
{
public:
    Pixart_I2cComPort(I2C &i2c, int address);

    virtual void writeRegister(uint8_t addr, uint8_t data);
    virtual uint8_t readRegister(uint8_t addr);

private:
    I2C &m_i2c;
    int m_address;
};

class Pixart_SpiComPort: public Pixart_ComPort
{
public:
    Pixart_SpiComPort(SPI &spi, DigitalOut &cs);

    virtual void writeRegister(uint8_t addr, uint8_t data);
    virtual uint8_t readRegister(uint8_t addr);

private:
    SPI &m_spi;
    DigitalOut &m_cs;
};
