/* PixArt Optical Finger Navigation, OFN, sensor driver.
 * By PixArt Imaging Inc.
 * Primary Engineer: Hill Chen (PixArt USA)
 *
 * License: Apache-2.0; http://www.apache.org/licenses/LICENSE-2.0
 */

#pragma once
#include <stdint.h>

static const uint8_t Pixart_OTS_9125_InitSetting[][2] =
{
    { 0x7F, 0x00 },     //Switch to bank0
    { 0x09, 0x5A },     //Disables write-protect.
    { 0x0D, 0x65 },     //Sets X-axis resolution (necessary value here will depend on physical design and application).
    { 0x0E, 0xFF },     //Sets Y-axis resolution (necessary value here will depend on physical design and application).
    { 0x19, 0x04 },     //Sets 12-bit X/Y data format.
    //{ 0x4B, 0x04 },     //Needed for when using low-voltage rail (1.7-1.9V): Power saving configuration.
    { 0x09, 0x00 },     //Enable write protect
};

static const uint8_t Pixart_OTS_9126_InitSetting[][2] =
{
    { 0x09, 0x5A },     //Disables write-protect.
    { 0x0D, 0x65 },     //Sets X-axis resolution (necessary value here will depend on physical design and application).
    //{ 0x0E, 0x00 },     //Sets Y-axis resolution (necessary value here will depend on physical design and application).
    { 0x0E, 0x05 },     //Sets Y-axis resolution to a small number for demo, set 0 to avoid Y count.
    { 0x19, 0x04 },     //Sets 12-bit X/Y data format.
    //{ 0x4B, 0x04 },     //Needed for when using low-voltage rail (1.7-1.9V): Power saving configuration.
    { 0x7C, 0x82 },
    { 0x2B, 0x6D },
    { 0x2D, 0x00 },
    { 0x09, 0x00 },     //Enable write protect
};

static const uint8_t Pixart_OTS_9150_InitSetting[][2] =
{
    { 0x7F, 0x00 },     //Switch to bank0
    { 0x09, 0x5A },     //Disables write-protect.
    { 0x0A, 0x0F },     // set X-axis resolution (depends on application)
    { 0x09, 0x00 },     //Enable write protect
};

static const uint8_t Pixart_OTS_9130_InitSetting[][2] =
{
    { 0x7F, 0x00 }, // switch to bank0, not allowed to perform SPIWriteRead
    { 0x05, 0xA8 }, // sleep mode disabled
    { 0x09, 0x5A }, // disable write protect
    { 0x51, 0x06 }, // set LD current source to 6
    { 0x0D, 0x1F }, // CPI resolution setting for X-direction
    { 0x0E, 0x1F }, // CPI resolution setting for Y-direction
    { 0x07, 0x00 },
    { 0x1B, 0x42 },
    { 0x2E, 0x40 },
    { 0x32, 0x40 },
    { 0x33, 0x02 },
    { 0x34, 0x00 },
    { 0x36, 0xE0 },
    { 0x38, 0xA0 },
    { 0x39, 0x01 },
    { 0x3E, 0x14 },
    { 0x44, 0x02 },
    { 0x4A, 0xE0 },
    { 0x4F, 0x02 },
    { 0x52, 0x0D }, // Turn off internal VDDA
    { 0x57, 0x03 },
    { 0x59, 0x03 },
    { 0x5B, 0x03 },
    { 0x5C, 0xFF },
    
    { 0x7F, 0x01 }, // switch to bank1, not allowed to perform SPIWriteRead
    { 0x00, 0x25 },
    { 0x07, 0x78 },
    { 0x20, 0x00 },
    { 0x21, 0x40 },
    { 0x23, 0x00 },
    { 0x2F, 0x64 },
    { 0x37, 0x30 },
    { 0x3B, 0x64 },
    { 0x43, 0x0A },
    { 0x59, 0x01 },
    { 0x5A, 0x01 },
    { 0x5C, 0x04 },
    { 0x5E, 0x04 },
    
    { 0x7F, 0x02 }, // switch to bank2, not allowed to perform SPIWriteRead
    { 0x51, 0x02 },
    
    { 0x7F, 0x03 }, // switch to bank3, not allowed to perform SPIWriteRead
    { 0x05, 0x0C },
    { 0x06, 0x0C },
    { 0x07, 0x0C },
    { 0x08, 0x0C },
    
    { 0x7F, 0x04 }, // switch to bank4, not allowed to perform SPIWriteRead
    { 0x05, 0x01 },
    { 0x53, 0x08 },
    
    { 0x7F, 0x05 }, // switch to bank5, not allowed to perform SPIWriteRead
    { 0x00, 0x02 },
    { 0x09, 0x01 },
    { 0x0A, 0x1C },
    { 0x0B, 0x24 },
    { 0x0C, 0x1C },
    { 0x0D, 0x24 },
    { 0x12, 0x08 },
    { 0x14, 0x02 },
    { 0x16, 0x02 },
    { 0x18, 0x1C },
    { 0x19, 0x24 },
    { 0x1A, 0x1C },
    { 0x1B, 0x24 },
    { 0x20, 0x08 },
    { 0x22, 0x02 },
    { 0x24, 0x02 },
    { 0x26, 0x88 },
    { 0x2F, 0x7C },
    { 0x30, 0x07 },
    { 0x3D, 0x00 },
    { 0x3E, 0x98 },
    
    { 0x7F, 0x06 }, // switch to bank6, not allowed to perform SPIWriteRead
    { 0x34, 0x03 },
    
    { 0x7F, 0x07 }, // switch to bank7, not allowed to perform SPIWriteRead
    { 0x00, 0x01 },
    { 0x02, 0xC4 },
    { 0x03, 0x13 },
    { 0x06, 0x0C },
    { 0x0F, 0x0A },
    { 0x14, 0x02 },
    { 0x35, 0x39 },
    { 0x36, 0x3F },
    { 0x46, 0x03 },
    { 0x47, 0x0F },
    { 0x4B, 0x97 },
    
    { 0x7F, 0x00 }, // switch to bank0, not allowed to perform SPIWriteRead
    { 0x09, 0x00 }, // enable write protect
};

static const uint8_t Pixart_OTS_5101_InitSetting[][2] =
{
    { 0x09,0x5A }, // disable write protect
    { 0x51,0x06 }, // To set LD power first, power should be <= 6
    { 0x7F,0x00 }, // Bank0, not allowed to perform SPIWriteRead
    { 0x05,0xA8 },
    { 0x07,0xCC },
    { 0x0A,0x17 },
    { 0x0D,0x05 },
    { 0x0E,0x05 },
    { 0x1B,0x43 },
    { 0x25,0x2E },
    { 0x26,0x35 },
    { 0x2E,0x40 },
    { 0x32,0x40 },
    { 0x33,0x02 },
    { 0x34,0x00 },
    { 0x36,0xE0 },
    { 0x3E,0x14 },
    { 0x44,0x02 },
    { 0x51,0x06 },
    { 0x52,0x0C },
    { 0x57,0x05 },
    { 0x59,0x03 },
    { 0x5B,0x04 },
    { 0x5D,0x3B },
    { 0x7C,0xC8 },
    
    { 0x7F,0x01 }, // Bank1, not allowed to perform SPIWriteRead
    { 0x00,0x2F },
    { 0x08,0x1C },
    { 0x0A,0x02 },
    { 0x19,0x40 },
    { 0x1B,0x10 },
    { 0x1D,0x18 },
    { 0x1F,0x12 },
    { 0x20,0x00 },
    { 0x21,0x80 },
    { 0x23,0x60 },
    { 0x25,0x64 },
    { 0x27,0x64 },
    { 0x2B,0x78 },
    { 0x2F,0x78 },
    { 0x39,0x78 },
    { 0x3B,0x78 },
    { 0x3D,0x78 },
    { 0x3F,0x78 },
    { 0x44,0x7E },
    { 0x45,0xF4 },
    { 0x46,0x01 },
    { 0x47,0x2C },
    { 0x49,0x90 },
    { 0x4A,0x05 },
    { 0x4B,0xDC },
    { 0x4C,0x07 },
    { 0x4D,0x08 },
    { 0x51,0x02 },
    { 0x52,0xBC },
    { 0x53,0x02 },
    { 0x54,0xBC },
    { 0x55,0x07 },
    { 0x56,0x08 },
    { 0x57,0x07 },
    { 0x58,0x08 },
    { 0x59,0x08 },
    { 0x5A,0x08 },
    
    { 0x7F,0x02 }, // Bank2, not allowed to perform SPIWriteRead
    { 0x07,0x1B },
    { 0x08,0x1F },
    { 0x09,0x23 },
    { 0x51,0x01 },
    
    { 0x7F,0x03 }, // Bank3, not allowed to perform SPIWriteRead
    { 0x07,0x07 },
    { 0x08,0x06 },
    { 0x2F,0x00 },
    { 0x30,0x20 },
    { 0x32,0x59 },
    { 0x33,0xD8 },
    { 0x34,0x4E },
    { 0x35,0x20 },
    { 0x36,0x5B },
    { 0x37,0xCC },
    { 0x38,0x50 },
    { 0x39,0x14 },
    
    { 0x7F,0x04 }, // Bank4, not allowed to perform SPIWriteRead
    { 0x05,0x01 },
    { 0x2C,0x06 },
    { 0x2E,0x0C },
    { 0x30,0x0C },
    { 0x32,0x06 },
    { 0x34,0x03 },
    { 0x38,0x17 },
    { 0x39,0x71 },
    { 0x3A,0x18 },
    { 0x3B,0x4D },
    { 0x3C,0x18 },
    { 0x3D,0x4D },
    { 0x3E,0x14 },
    { 0x3F,0xD1 },
    { 0x40,0x14 },
    { 0x41,0xDD },
    { 0x42,0x0A },
    { 0x43,0x6C },
    { 0x44,0x08 },
    { 0x45,0xAD },
    { 0x46,0x06 },
    { 0x47,0xF2 },
    { 0x48,0x06 },
    { 0x49,0xEC },
    { 0x4A,0x06 },
    { 0x4B,0xEC },
    { 0x53,0x08 },
    
    { 0x7F,0x05 }, // Bank5, not allowed to perform SPIWriteRead
    { 0x03,0x00 },
    { 0x09,0x01 },
    { 0x0B,0xFF },
    { 0x0D,0xFF },
    { 0x0F,0xFF },
    { 0x11,0xFF },
    { 0x12,0xD2 },
    { 0x13,0xD2 },
    { 0x19,0xFF },
    { 0x1B,0xFF },
    { 0x1D,0xFF },
    { 0x1F,0xFF },
    { 0x20,0xD2 },
    { 0x21,0xD2 },
    { 0x2F,0x7C },
    { 0x30,0x05 },
    { 0x41,0x02 },
    { 0x53,0xFF },
    { 0x5F,0x02 },
    
    { 0x7F,0x06 }, // Bank6, not allowed to perform SPIWriteRead
    { 0x2A,0x05 }, // Write ONLY address, not allowed to perform SPIWriteRead
    { 0x35,0x19 },
    
    { 0x7F,0x07 }, // Bank7, not allowed to perform SPIWriteRead
    { 0x00,0x01 },
    { 0x14,0x03 },
    { 0x15,0x14 },
    { 0x46,0x03 },
    
    { 0x7F,0x00 }, // Bank0, not allowed to perform SPIWriteRead
};
