/* PixArt Optical Finger Navigation, OFN, sensor driver.
 * By PixArt Imaging Inc.
 * Primary Engineer: Hill Chen (PixArt USA)
 *
 * License: Apache-2.0; http://www.apache.org/licenses/LICENSE-2.0
 */
 
#include "Pixart_OTS_GrabData.h"

Pixart_OTS_OtsData Pixart_OTS_GrabData_12bitXy::grab(Pixart_ComPort &com_port)
{
    int16_t deltaX_low = com_port.readRegister(0x03);
    int16_t deltaY_low = com_port.readRegister(0x04);
    int16_t deltaX_high = 0, deltaY_high = 0;

    int16_t deltaXY_h = com_port.readRegister(0x12);
    deltaX_high = (deltaXY_h << 4) & 0xF00;
    deltaY_high = (deltaXY_h << 8) & 0xF00;

    if (deltaX_high & 0x800)
        deltaX_high |= 0xf000;
    if (deltaY_high & 0x800)
        deltaY_high |= 0xf000;

    Pixart_OTS_OtsData otsData;
    otsData.x = deltaX_high | deltaX_low;
    otsData.y = deltaY_high | deltaY_low;
    return otsData;
}

Pixart_OTS_OtsData Pixart_OTS_GrabData_16bitXy::grab(Pixart_ComPort &com_port)
{
    int16_t deltaX_low = com_port.readRegister(0x03);
    int16_t deltaY_low = com_port.readRegister(0x04);
    int16_t deltaX_high = 0, deltaY_high = 0;

    deltaX_high = com_port.readRegister(0x11) << 8;
    deltaY_high = com_port.readRegister(0x12) << 8;

    Pixart_OTS_OtsData otsData;
    otsData.x = deltaX_high | deltaX_low;
    otsData.y = deltaY_high | deltaY_low;
    return otsData;
}

Pixart_OTS_OtsData Pixart_OTS_GrabData_16bitXOnly::grab(Pixart_ComPort &com_port)
{
    int16_t deltaX_low = com_port.readRegister(0x03);
    int16_t deltaX_high = 0;
    deltaX_high = com_port.readRegister(0x04) << 8;
    
    Pixart_OTS_OtsData otsData;
    otsData.x = deltaX_high | deltaX_low;
    otsData.y = 0;
    return otsData;
}
