/* PixArt Optical Finger Navigation, OFN, sensor driver.
 * By PixArt Imaging Inc.
 * Primary Engineer: Hill Chen (PixArt USA)
 *
 * License: Apache-2.0; http://www.apache.org/licenses/LICENSE-2.0
 */
 
#include "Pixart_ComPort.h"

Pixart_I2cComPort::Pixart_I2cComPort(I2C &i2c, int address): m_i2c(i2c), m_address(address)
{
    m_i2c.frequency(400000);
}

void Pixart_I2cComPort::writeRegister(uint8_t addr, uint8_t data)
{
    char data_write[2];

    data_write[0] = addr;
    data_write[1] = data;
    m_i2c.write(m_address, data_write, 2, 0);
}

uint8_t Pixart_I2cComPort::readRegister(uint8_t addr)
{
    char data_write[2];
    char data_read[2];

    data_write[0] = addr;
    m_i2c.write(m_address, data_write, 1, 0);
    m_i2c.read(m_address, data_read, 1, 0);

    return data_read[0];
}


Pixart_SpiComPort::Pixart_SpiComPort(SPI &spi, DigitalOut &cs): m_spi(spi), m_cs(cs)
{
    m_spi.format(8, 3);
    m_spi.frequency(1000000);

    m_cs = 1;
}

void Pixart_SpiComPort::writeRegister(uint8_t addr, uint8_t data)
{
    m_cs = 0;
    addr = addr | 0x80;
    m_spi.write(addr);
    m_spi.write(data);
    m_cs = 1;
}

uint8_t Pixart_SpiComPort::readRegister(uint8_t addr)
{
    m_cs = 0;
    addr = addr & 0x7F;
    m_spi.write(addr);
    //wait_us(1);
    uint8_t data_read = m_spi.write(0x00);
    m_cs = 1;

    return data_read;
}
