/* PixArt Optical Finger Navigation, OFN, sensor driver.
 * By PixArt Imaging Inc.
 * Primary Engineer: Hill Chen (PixArt USA)
 *
 * License: Apache-2.0; http://www.apache.org/licenses/LICENSE-2.0
 */

#include "Build_info.h"

#ifdef DEBUG
    #define DEBUG_PRINT(...)    m_pc->printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT(...)    {}
#endif

#define P_ADDR  (0x57 << 1) //A350 I2C address, A1/A0 = high
#define I2C_ADDR P_ADDR
#define PXI_WMI 0x88

class Pixart_OFN
{
    private:        
        Serial  *m_pc;
        I2C     *m_i2c;
        Ticker  m_ticker;
        float   m_Period;
        
        int8_t  deltaX, deltaY;
        int     totalX, totalY;
        
        bool    Sensor_Init();
        //void    periodicCallback();
       
        void    writeRegister(uint8_t addr, uint8_t data);
        uint8_t readRegister(uint8_t addr);
        
        void    load(const uint8_t array[][2], uint8_t arraySize);
        void    grabData(void);
        void    printData(void);
       
    public:
       Pixart_OFN(I2C *i2c, float Period, bool &Result);
       Pixart_OFN(I2C *i2c, Serial *pc, float Period, bool &Result);
       void periodicCallback();
       void print_build_info();
};

const uint8_t initialize[][2] = {
    { 0xC9, 0x61 },     //OFN Engine settings.
    //{ 0x6C, 0xA0 },     //Set GPIO pin as button input.
};
#define initialize_size (sizeof(initialize)/sizeof(initialize[0]))
