/* PixArt Optical Finger Navigation, OFN, sensor driver.
 * By PixArt Imaging Inc.
 * Primary Engineer: Hill Chen (PixArt USA)
 *
 * License: Apache-2.0; http://www.apache.org/licenses/LICENSE-2.0
 */
 
#include "mbed.h"
#include "Pixart_OFN.h"

//Pixart_OFN::Pixart_OFN(I2C *i2c, float Period, bool &Result){
Pixart_OFN::Pixart_OFN(I2C *i2c, Serial *pc, float Period, bool &Result){
    m_pc = pc;
    pc->baud (115200);  wait_ms(500);
    
    DEBUG_PRINT("\r\n >> Constructor");
    print_build_info();
    
    m_i2c = i2c;
    m_i2c->frequency(400000);
    
    m_Period = Period;
        
    Result = Sensor_Init();
    
    DEBUG_PRINT("\r\n << Constructor");
}

bool Pixart_OFN::Sensor_Init(){
    DEBUG_PRINT("\r\n >> Sensor Init");
    
    writeRegister(0x3A, 0x5A);      //Soft-reset the chip.
    if(readRegister(0x00) != PXI_WMI){
        DEBUG_PRINT("\r\n << Sensor_Init (Fail)");
        return false;
    }
    
    totalX = 0; totalY = 0;
    load(initialize, initialize_size);
#ifdef USE_CALLBACK        
    m_ticker.attach(callback(this, &Pixart_OFN::periodicCallback), m_Period);
#endif    
    DEBUG_PRINT("\r\n << Sensor_Init (Success)");
    
    return true;
}

void Pixart_OFN::periodicCallback(){
    DEBUG_PRINT("\r\n >> Callback");
    
    if(readRegister(0x02) & 0x80){
        grabData();
        printData();
    }
    
    DEBUG_PRINT("\r\n << Callback");
}

void Pixart_OFN::writeRegister(uint8_t addr, uint8_t data){
    char data_write[2];
    
    data_write[0] = addr;
    data_write[1] = data;
    m_i2c->write(I2C_ADDR, data_write, 2, 0);
}

uint8_t Pixart_OFN::readRegister(uint8_t addr){
    char data_write[2];
    char data_read[2];
    
    data_write[0] = addr;
    m_i2c->write(I2C_ADDR, data_write, 1, 0);
    m_i2c->read(I2C_ADDR, data_read, 1, 0);
    
    return data_read[0];
}

void Pixart_OFN::load(const uint8_t array[][2], uint8_t arraySize){
    for(uint8_t q = 0; q < arraySize; q++)
    {
        writeRegister(array[q][0], array[q][1]);    //Writes the given array of registers/data.
    }
}

void Pixart_OFN::grabData(void){
    deltaX = readRegister(0x03);        //Grabs data from the proper registers.
    deltaY = readRegister(0x04);
    writeRegister(0x02, 0x00);          //Clear EVENT and motion registers.
}

void Pixart_OFN::printData(void){
    if((deltaX != 0) || (deltaY != 0))      //If there is deltaX or deltaY movement, print the data.
    {
        totalX += deltaX;
        totalY += deltaY;
        
        m_pc->printf("deltaX: %d\t\t\tdeltaY: %d\n\r", deltaX, deltaY);    //Prints each individual count of deltaX and deltaY.
        m_pc->printf("X-axis Counts: %d\t\tY-axis Counts: %d\n\r", totalX, totalY);  //Prints the total movement made during runtime.
    }
    
    deltaX = 0;                             //Resets deltaX and Y values to zero, otherwise previous data is stored until overwritten.
    deltaY = 0;
}

void Pixart_OFN::print_build_info(){
    m_pc->printf("\r\n\n PixArt Mbed eval code, %s, %s", PRODUCT, MODEL);
    m_pc->printf("\r\n Fw version: %s, Hw version: %s, mbed version: %d", FW_VERSION, HW_VERSION, MBED_VERSION);
    m_pc->printf("\r\n Build time: %s  %s\r\n", __TIME__, __DATE__);
}
