/* PixArt Optical Finger Navigation, OFN, sensor driver.
 * By PixArt Imaging Inc.
 * Primary Engineer: Hill Chen (PixArt USA)
 *
 * License: Apache-2.0; http://www.apache.org/licenses/LICENSE-2.0
 */

#include "Build_info.h"

#ifdef DEBUG
    #define DEBUG_PRINT(...)    m_pc->printf(__VA_ARGS__)
#else
    #define DEBUG_PRINT(...)    {}
#endif

#define P_ADDR  (0x33 << 1) //P3003 I2C address, ID1/ID0 = low
#define I2C_ADDR P_ADDR
#define PXI_WMI 0x30

class Pixart_OFN
{
    private:        
        Serial  *m_pc;
        I2C     *m_i2c;
        Ticker  m_ticker;
        float   m_Period;
        
        int8_t  deltaX, deltaY;
        int     totalX, totalY;
        
        bool    Sensor_Init();
        //void    periodicCallback();
       
        void    writeRegister(uint8_t addr, uint8_t data);
        uint8_t readRegister(uint8_t addr);
        
        void    load(const uint8_t array[][2], uint8_t arraySize);
        void    grabData(void);
        void    printData(void);
       
    public:
       Pixart_OFN(I2C *i2c, float Period, bool &Result);
       Pixart_OFN(I2C *i2c, Serial *pc, float Period, bool &Result);
       void periodicCallback();
       void print_build_info();
};

const uint8_t initialize[][2] = {
    //OFN Engine settings.
    { 0x09,0x5A }, 
    { 0x7F,0x01 }, 
    { 0x23,0x1E }, 
    { 0x2E,0x48 }, 
    { 0x7F,0x00 }, 
    { 0x0D,0x0A },  //IQ_TH
    { 0x1D,0x1B }, 
    { 0x2A,0x82 }, 
    { 0x2B,0x78 }, 
    { 0x2C,0x50 }, 
    { 0x2D,0x46 }, 
    { 0x3D,0xA1 },    
    { 0x4C,0x90 },
    { 0x4D,0x18 },  
    { 0x4F,0x10 }, 
    { 0x56,0x00 }, 
    { 0x7A,0x35 }, 
    { 0x09,0x00 },
};
#define initialize_size (sizeof(initialize)/sizeof(initialize[0]))
