#include "mbed.h"
#include "PAC7620_30Set.h"
#include "Gesture.h"



#define PAC7620_30_ADDR     (0xE6) //PAC7620 address shift 1-bit
#define I2C_ADDR PAC7620_30_ADDR
#define PXI_WMI 0x20
#define ID_7620 0x01
#define ID_7630 0x00
#define GestureRegAddrL  0x43
#define GestureRegAddrH  0x44
#define DebounceT 300       //debounce time, unit:ms


Pixart_Gesture::Pixart_Gesture(I2C *i2c, int Period,GestureCallback callback,bool &Result)
{    
    m_i2c = i2c;
    m_GestureCallback = callback;
    //m_pc = pc;
    m_Period = Period;
    
    
    Result=PAC7620_30_init();    
}



bool Pixart_Gesture::PAC7620_30_init()
{   uint8_t q;

    readRegister(0x00);
    wait_ms(50);

    if(readRegister(0x00) == PXI_WMI)
        ;//m_pc->printf("I2C Link Successful!\n\r");
    else{
        //m_pc->printf(" I2C Link Fail!\n\r");
        return false;
    }
    
    if(readRegister(0x02) == ID_7620)
    {
       // m_pc->printf("PAC7620 detected.\n\r");
        
        writeRegister(0xff, 0x00);  //wakeup
        wait_ms(10);                //make a delay
        for(q=0;q<INIT_Ges7620_REG_ARRAY_SIZE;q++)
            writeRegister(init_ges7620_register_array[q][0], init_ges7620_register_array[q][1]);
        
        wait_ms(DebounceT);  //debounce, clean data
        readRegister(GestureRegAddrH); readRegister(GestureRegAddrL);
        Flag_7630 = 0;
    }
    else if(readRegister(0x02) == ID_7630)
    {
        //m_pc->printf("PAC7630 detected.\n\r");
        
        writeRegister(0xff, 0x00);  //wakeup
        wait_ms(10);                //make a delay
        for(q=0;q<INIT_Ges7630_REG_ARRAY_SIZE;q++)
            writeRegister(init_ges7630_register_array[q][0], init_ges7630_register_array[q][1]);
        
        wait_ms(DebounceT);  //debounce, clean data
        readRegister(GestureRegAddrH); readRegister(GestureRegAddrL);
        
        Flag_7630 = 1;
    }
    else
       ;// m_pc->printf("Device not support.\n\r");
    
    m_ticker.attach_us(this,&Pixart_Gesture::periodicCallback, m_Period*1000);
    
    //m_pc->printf("\n\r~~~Start Real-time Gesture Demo~~~ \n\r");
    
    return true;
}

void Pixart_Gesture::periodicCallback(void)
{
     uint16_t gesture_code;

     gesture_code = (readRegister(GestureRegAddrH)<<8) + readRegister(GestureRegAddrL);
     //pc.printf("Gesture Code: 0x %4X\n\r", gesture_code);
    //UP,DOWN,LEFT,RIGHT,PUSH,POLL,CLOCKWISE,COUNTER_CLOCKWISE,WAVE};  
     if(gesture_code != 0) 
     {            
         switch (gesture_code) 
         {
                case 0x01: // up
                    if(Flag_7630 == 0)
                        m_GestureCallback(DOWN);
                    else
                        m_GestureCallback(LEFT);
                        
                    //m_pc->printf("up 0x%4X\n\r", gesture_code);
                    break;
                case 0x02: // down
                    if(Flag_7630 == 0)
                        m_GestureCallback(UP);
                    else
                        m_GestureCallback(RIGHT);
                    
                    //m_pc->printf("down 0x%4X\n\r", gesture_code);
                    break;
                case 0x04: // left
                    if(Flag_7630 == 0)
                        m_GestureCallback(RIGHT);
                    else
                        m_GestureCallback(DOWN);
                    //m_pc->printf("left 0x%4X\n\r", gesture_code);
                    break;
                case 0x08: // right
                    if(Flag_7630 == 0)
                        m_GestureCallback(LEFT);
                    else
                        m_GestureCallback(UP);
                    //m_pc->printf("right 0x%4X\n\r", gesture_code);
                    break;
                case 0x10: // push
                    m_GestureCallback(PUSH);
                    //m_pc->printf("push 0x%4X\n\r", gesture_code);
                    break;
                case 0x20: // pop
                    m_GestureCallback(POLL);
                    //m_pc->printf("pop 0x%4X\n\r", gesture_code);
                    break;
                case 0x40: // rotate right
                    m_GestureCallback(CLOCKWISE);
                    //m_pc->printf("rotate right 0x%4X\n\r", gesture_code);
                    break;
                case 0x80: // rotate left
                    m_GestureCallback(COUNTER_CLOCKWISE);
                    //m_pc->printf("rotate left 0x%4X\n\r", gesture_code);
                    break;
                case 0x100:// wave
                    m_GestureCallback(WAVE);
                    //m_pc->printf("wave 0x%4X\n\r", gesture_code);
                    break;
            }
            readRegister(GestureRegAddrH); readRegister(GestureRegAddrL);
    }
}



void Pixart_Gesture::writeRegister(uint8_t addr, uint8_t data)
{
    char data_write[2];
    
    data_write[0] = addr;
    data_write[1] = data;
    m_i2c->write(I2C_ADDR, data_write, 2, 0);
}
uint8_t Pixart_Gesture::readRegister(uint8_t addr)
{
    char data_write[2];
    char data_read[2];
    
    data_write[0] = addr;
    m_i2c->write(I2C_ADDR, data_write, 1, 0);
    m_i2c->read(I2C_ADDR, data_read, 1, 0);
    return data_read[0];
}