/*
 *  Pixart support 9 gesture type
 *
 */
enum PIXART_GESTURE_TYPE{UP,DOWN,LEFT,RIGHT,PUSH,POLL,CLOCKWISE,COUNTER_CLOCKWISE,WAVE};

/* The callback function when Gesture happen
   Type ==> The Gesture type recognize by Pixart's Gesture class
 */
typedef  void (*GestureCallback)(PIXART_GESTURE_TYPE Type);

class Pixart_Gesture
{
    private:
       Ticker  m_ticker;
       I2C     *m_i2c;
       //Serial  *m_pc;
       int m_Period;
       uint8_t Flag_7630 ;
       
       GestureCallback m_GestureCallback;       
       void periodicCallback(void);       
       bool PAC7620_30_init();
       
       void writeRegister(uint8_t addr, uint8_t data);
       uint8_t readRegister(uint8_t addr);       
       
       
    public:           
       /* 
        * The initial function for Gesture class 
        * i2c ==> The I2C object from outside, the clock rate should be 400k
        * Period ==> The polling rate for gesture, in ms
        * callback ==> The call back function for gesture status
        * Result ==> The result for initialize
        */
       Pixart_Gesture(I2C *i2c, int Period,GestureCallback callback,bool &Result);                                             
};