
/* The callback function when motion happen
   
 */
typedef  void (*OTSCallback)(int16_t value);

// Helper macro
#define BIT_CLEAR(REG,MASK)         (REG &= ~MASK)
#define BIT_SET(REG,MASK)           (REG |=  MASK)
#define IS_BIT_CLEAR(REG,MASK)      ((REG & MASK)==0x00)
#define IS_BIT_SET(REG,MASK)        ((REG & MASK)==MASK)

class Pixart_OTS
{
    private:
       Ticker  m_ticker;
       I2C     *m_i2c;
       //Serial  *m_pc;
       int m_Period;
       uint8_t m_Address;
       bool m_WriteEnable;
       
       OTSCallback m_OTSCallback;       
       void periodicCallback(void);       
       bool PMT9123_init();
       void PMT9123_ReadMotion();
       
       // Internal read and write function that is only single transaction
       void writeRegister(uint8_t addr, uint8_t data);
       uint8_t readRegister(uint8_t addr);       
       
    public:           
       /* 
        * The initial function for Gesture class 
        * i2c ==> The I2C object from outside, the clock rate should be 400k
        * Period ==> The polling rate for gesture, in ms
        * callback ==> The call back function for gesture status
        * Result ==> The result for initialize
        */
       Pixart_OTS(I2C *i2c, int Period,OTSCallback callback,bool &Result);                                             
       
       // Public register read and write function, which include steps to ensure successful write and read
       uint8_t Register_Write(uint8_t addr, uint8_t data);
       uint8_t Register_Read(uint8_t addr);
};