/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "Gesture.h"
/*DigitalOut ledup(LED1);
DigitalOut leddn(LED4);
DigitalOut ledlt(LED3);
DigitalOut ledrt(LED2);*/
DigitalOut ledup(p15);//D1
DigitalOut leddn(p13);//D3
DigitalOut ledlt(p12);//D4
DigitalOut ledrt(p14);//D2
DigitalIn btn1(p17);//setting selection
DigitalIn btn2(p18);
DigitalIn btn3(p19);
DigitalIn btn4(p20);
DigitalOut ld1(LED1);//setting indicator
DigitalOut ld2(LED2);
DigitalOut ld3(LED3);
DigitalOut ld4(LED4);
Serial  pc(USBTX, USBRX);
I2C i2c(I2C_SDA0, I2C_SCL0);
Ticker  ticker;

#define dly 100             //LED delay

void LED_Code(uint8_t OnOff);   //LED on/off code. bit3~0: right/left/down/up
void Gesture_LED(PIXART_GESTURE_TYPE gesture);

void GetGestute(PIXART_GESTURE_TYPE gesture)
{
    //UP,DOWN,LEFT,RIGHT,PUSH,POLL,CLOCKWISE,COUNTER_CLOCKWISE,WAVE};
    switch (gesture)
    {
        case UP:
          pc.printf("UP \r\n");
          break;
        case DOWN:
          pc.printf("DOWN \r\n");
          break;
        case LEFT:
          pc.printf("LEFT \r\n");
          break;
        case RIGHT:
          pc.printf("RIGHT \r\n");
          break;
        case PUSH:
          pc.printf("PUSH \r\n");
          break;
        case POLL:
          pc.printf("POLL \r\n");
          break;
        case CLOCKWISE:
          pc.printf("CLOCKWISE \r\n");
          break;
        case COUNTER_CLOCKWISE:
          pc.printf("COUNTER_CLOCKWISE \r\n");
          break;
        case WAVE:
          pc.printf("WAVE \r\n");
          break;        
        default:
          pc.printf("Nothing happen \r\n");          
    }  
    Gesture_LED(gesture);
}

void Gesture_LED(PIXART_GESTURE_TYPE gesture)
{    
    switch (gesture)
    {
    case UP:      //up
        LED_Code(1);
        wait_ms(400);
        LED_Code(0);
        break;
    case DOWN:      //down
        LED_Code(2);
        wait_ms(400);
        LED_Code(0);
        break;
    case LEFT:      //left
        LED_Code(4);
        wait_ms(400);
        LED_Code(0);
        break;
    case RIGHT:      //right
        LED_Code(8);
        wait_ms(400);
        LED_Code(0);
        break;
    case CLOCKWISE:      //clockwise
        LED_Code(1); //up
        LED_Code(0);
        LED_Code(8); //right
        LED_Code(0);
        LED_Code(2); //down
        LED_Code(0);
        LED_Code(4); //left
        LED_Code(0);
        LED_Code(1); //up
        LED_Code(0);
        break;
    case COUNTER_CLOCKWISE:      //counter-clockwise
        LED_Code(1); //up
        LED_Code(0);
        LED_Code(4); //left
        LED_Code(0);
        LED_Code(2); //down
        LED_Code(0);
        LED_Code(8); //right
        LED_Code(0);
        LED_Code(1); //up
        LED_Code(0);
        break;
    case PUSH:      //forward
        LED_Code(13); //up/left/right
        wait_ms(400);
        LED_Code(0);
        break;
    case POLL:      //backward
        LED_Code(14); //down/left/right
        wait_ms(400);
        LED_Code(0);
        break;
    case WAVE:     //wave
        LED_Code(15); //all on
        LED_Code(0);
        LED_Code(15); //all on
        LED_Code(0);
        LED_Code(15); //all on
        LED_Code(0);
        break;
    default:
        LED_Code(0);
        break;
    }
}

int main(void)
{  
    pc.baud (115200);    
    pc.printf("Start Pixart Gesture demo\n\r");
    
    i2c.frequency(400000);    
    
    LED_Code(0);
    
    bool Result = false;
    Pixart_Gesture *m_Gesture = new Pixart_Gesture(&i2c,100,GetGestute,Result);
    
    if(Result == true)
    {
        pc.printf("Initial Pixart Gesture successful\n\r");
    }
    else
    {
        pc.printf("Initial Pixart Gesture fail\n\r");    
    }
        
        
    while(true)
        ;
}



void LED_Code(uint8_t OnOff)
{
    switch (OnOff) {
    case 0:
        ledrt = 1; ledlt = 1; leddn = 1; ledup = 1; wait_ms(dly);//make a delay
        break;
    case 1:
        ledrt = 1; ledlt = 1; leddn = 1; ledup = 0; wait_ms(dly);//make a delay
        break;
    case 2:
        ledrt = 1; ledlt = 1; leddn = 0; ledup = 1; wait_ms(dly);//make a delay
        break;
    case 3:
        ledrt = 1; ledlt = 1; leddn = 0; ledup = 0; wait_ms(dly);//make a delay
        break;
    case 4:
        ledrt = 1; ledlt = 0; leddn = 1; ledup = 1; wait_ms(dly);//make a delay
        break;
    case 5:
        ledrt = 1; ledlt = 0; leddn = 1; ledup = 0; wait_ms(dly);//make a delay
        break;
    case 6:
        ledrt = 1; ledlt = 0; leddn = 0; ledup = 1; wait_ms(dly);//make a delay
        break;
    case 7:
        ledrt = 1; ledlt = 0; leddn = 0; ledup = 0; wait_ms(dly);//make a delay
        break;
    case 8:
        ledrt = 0; ledlt = 1; leddn = 1; ledup = 1; wait_ms(dly);//make a delay
        break;
    case 9:
        ledrt = 0; ledlt = 1; leddn = 1; ledup = 0; wait_ms(dly);//make a delay
        break;
    case 10:
        ledrt = 0; ledlt = 1; leddn = 0; ledup = 1; wait_ms(dly);//make a delay
        break;
    case 11:
        ledrt = 0; ledlt = 1; leddn = 0; ledup = 0; wait_ms(dly);//make a delay
        break;
    case 12:
        ledrt = 0; ledlt = 0; leddn = 1; ledup = 1; wait_ms(dly);//make a delay
        break;
    case 13:
        ledrt = 0; ledlt = 0; leddn = 1; ledup = 0; wait_ms(dly);//make a delay
        break;
    case 14:
        ledrt = 0; ledlt = 0; leddn = 0; ledup = 1; wait_ms(dly);//make a delay
        break;
    case 15:
        ledrt = 0; ledlt = 0; leddn = 0; ledup = 0; wait_ms(dly);//make a delay
        break;
    default:
        ledrt = 1; ledlt = 1; leddn = 1; ledup = 1; wait_ms(dly);//make a delay
        break;
    }
}



