/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

/* PAA5101EW: Optical Tracking Sensor.
 * By PixArt Imaging Inc.
 * Primary Engineer: Hill Chen (PixArt USA)
 *
 * License: Apache-2.0; http://www.apache.org/licenses/LICENSE-2.0
 */
 
/* Demo Code Revision History
 * V1.0: March 26, 2019
 * First release.
 */

#include "mbed.h"
#include "Pixart_OTS.h"

Serial  pc(USBTX, USBRX);
SPI spi(p23, p24, p25); //mosi, miso, sclk
DigitalOut cs(p22);     //chip select
DigitalOut ldp_enl_pin(p20);//laser diode control, low enable

static const Pixart_OTS_Model OTS_MODEL = PIXART_OTS_MODEL_5101;

int main()
{
    pc.baud(115200);

    Pixart_OTS *pixart_ots = create_pixart_ots(OTS_MODEL, pc, spi, cs, ldp_enl_pin);

    if (!pixart_ots)
    {
        pc.printf("\r\n\n Not on library support list %d", OTS_MODEL);
        while (true);
    }

    bool result = pixart_ots->sensor_init();

    if (result)
    {
        pc.printf("\r\n\n %s %s initialization successfully\r\n", PRODUCT, pixart_ots->get_model().c_str());
    }  
    else
    {
        pc.printf("\r\n\n %s %s fail on initialization", PRODUCT, pixart_ots->get_model().c_str());
        while (true);
    }

    while (true) {
#ifndef USE_CALLBACK           
        pixart_ots->periodic_callback();
        wait_ms(250);
#endif        
    }
}

