/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

/* ADBM-A350: Finger navigation chip.
 * By PixArt Imaging Inc.
 * Primary Engineer: Hill Chen (PixArt USA)
 *
 * License: Apache-2.0; http://www.apache.org/licenses/LICENSE-2.0
 */
 
/* Revision History
 * V1.0: February 27, 2019
 * First release.
 */


#include "mbed.h"
#include "Pixart_OFN.h"

Serial  pc(USBTX, USBRX);
I2C i2c(I2C_SDA0, I2C_SCL0);

// main() runs in its own thread in the OS
int main()
{
    bool Result = false;
    Pixart_OFN *m_Sensor = new Pixart_OFN(&i2c, &pc, 0.25f, Result);
    if(Result)  pc.printf("\r\n\n %s %s initialization successfully\r\n", PRODUCT, MODEL);
    else{       pc.printf("\r\n\n %s %s fail on initialization", PRODUCT, MODEL);
        while (true)    ;
    }

    while (true){
#ifndef USE_CALLBACK           
        m_Sensor->periodicCallback();
        wait_ms(250);
#endif        
    }
}
