// ADBM-A350: Finger navigation chip.
// Version: 1.0
// Latest Revision Date: 14 June 2018
// By PixArt Imaging Inc.
// Primary Engineer: Vincent Yeh (PixArt USA)

/*
//=======================
//Revision History
//=======================
Version 1.0 -- 14 June 2018
First release.
*/

#include "mbed.h"
#include "registerArrays.h"
//#include "I2CcommFunctions.h"
#include "SPIcommFunctions.h"
//Make sure you only have one of either SPIcommFunctions or I2CcommFunctions enabled. You cannot include both headers.

int main()
{
    pc.baud(115200);                    // Set baud rate to 115200. Remember to sync serial terminal baud rate to the same value.

    #ifdef SPImode
    IO_sel = 1;                         // Set IO_select pin to be HIGH for SPI.
    spi.format(8,3);                    // Set SPI to 8 bits with inverted polarity and phase-shifted to second edge.
    spi.frequency(100000);             // Set frequency for SPI communication.
    cs = 1;                             // Initialize chip select as inactive.
    #endif
    
    #ifdef I2Cmode
    IO_sel = 0;                         // Set IO_select pin to be LOW for I2C.
    i2c.frequency(400000);              // Set frequency for I2C communication.
    cs = 1;                             // These two pins are used to determine the device's slave ID.
    MOSI = 1;
    #endif
    
    shutdown = 0;
    writeRegister(0x3A, 0x5A);          //Soft-reset the chip.
    
    pc.printf("Program START\n\r");
    
    pc.printf("ID Check: %2X\n\r", readRegister(0x00)); //Checks product ID to make sure communication protocol is working properly.
    if(readRegister(0x00) != 0x88)
    {
        pc.printf("Communication protocol error! Terminating program.\n\r");
        return 0;
    }
    
    load(initialize, initialize_size);  //Load register settings from the "initialize" array (see registerArrays.h)
    
    while(1)
    {
        //pc.printf("MOTION bit: %2X\n\r", readRegister(0x02));   //Prints EVENT register for debugging.
        
        if(readRegister(0x02) & 0x80)
        {
            grabData();
            printData();
        }
    }
}
