// PAT9125EL: Miniature Optical Navigation Chip reference code.
// Version: 1.0
// Latest Revision Date: 16 Feb. 2018
// By PixArt Imaging Inc.
// Primary Engineer: Vincent Yeh (PixArt USA)

/*
//=======================
//Revision History
//=======================
Version 1.0 -- 16 Feb. 2018
First release.
*/

#include "mbed.h"
#include "registerArrays.h"
//#include "SPIcommFunctions.h"
#include "I2CcommFunctions.h"
//Make sure you only have SPIcommFunctions or I2CcommFunctions enabled. You cannot include both headers.

int main()
{
    pc.baud(115200);                    // Set baud rate to 115200. Remember to sync serial terminal baud rate to the same value.

    #ifdef SPImode
    spi.format(8,3);                    // Set SPI to 8 bits with inverted polarity and phase-shifted to second edge.
    spi.frequency(1000000);             // Set frequency for SPI communication.
    cs = 1;                             // Initialize chip select as inactive.
    #endif
    
    #ifdef I2Cmode
    i2c.frequency(400000);              // Set frequency for I2C communication.
    #endif
    
    pc.printf("Program START\n\r");
    
    pc.printf("ID Check: %2X\n\r", readRegister(0x00)); //Checks product ID to make sure communication protocol is working properly.
    if(readRegister(0x00) != 0x31)
    {
        pc.printf("Communication protocol error! Terminating program.\n\r");
        return 0;
    }
    
    writeRegister(0x06, 0x97);          //Software reset (i.e. set bit7 to 1)
    wait_ms(1);                         //Delay 1 ms for chip reset timing.
    writeRegister(0x06, 0x17);          //Ensure software reset is done and chip is no longer in that state.
    
    load(initialize, initialize_size);  //Load register settings from the "initialize" array
    
    
    
    if(readRegister(0x5E) == 0x04)      //These unlisted registers are used for internal recommended settings.
    {
        writeRegister(0x5E, 0x08);
        
        if(readRegister(0x5D) == 0x10)
            writeRegister(0x5D, 0x19);
    }
    
    writeRegister(0x09, 0x00);  // enable write protect.
    
    while(1)
    {
        //pc.printf("MOTION bit: %2X\n\r", (readRegister(0x02) & 0x80) >> 7);   //Prints motion bit for debugging. 1 = motion detected. 0 = no motion detected.
        
        if(readRegister(0x02) & 0x80)
        {
            grabData();
            printData();
        }
    }
}
