const uint8_t initialize[][2] = {
    { 0x7F,0x00 }, // Bank0, not allowed to perform SPIWriteRead
    { 0x05,0xA8 },
    { 0x07,0xCC },
    { 0x0A,0x17 },
    { 0x0D,0x05 },
    { 0x0E,0x05 },
    { 0x1B,0x43 },
    { 0x25,0x2E },
    { 0x26,0x35 },
    { 0x2E,0x40 },
    { 0x32,0x40 },
    { 0x33,0x02 },
    { 0x34,0x00 },
    { 0x36,0xE0 },
    { 0x3E,0x14 },
    { 0x44,0x02 },
    { 0x51,0x06 },
    { 0x52,0x0C },
    { 0x57,0x05 },
    { 0x59,0x03 },
    { 0x5B,0x04 },
    { 0x5D,0x3B },
    { 0x7C,0xC8 },
    
    { 0x7F,0x01 }, // Bank1, not allowed to perform SPIWriteRead
    { 0x00,0x2F },
    { 0x08,0x1C },
    { 0x0A,0x02 },
    { 0x19,0x40 },
    { 0x1B,0x10 },
    { 0x1D,0x18 },
    { 0x1F,0x12 },
    { 0x20,0x00 },
    { 0x21,0x80 },
    { 0x23,0x60 },
    { 0x25,0x64 },
    { 0x27,0x64 },
    { 0x2B,0x78 },
    { 0x2F,0x78 },
    { 0x39,0x78 },
    { 0x3B,0x78 },
    { 0x3D,0x78 },
    { 0x3F,0x78 },
    { 0x44,0x7E },
    { 0x45,0xF4 },
    { 0x46,0x01 },
    { 0x47,0x2C },
    { 0x49,0x90 },
    { 0x4A,0x05 },
    { 0x4B,0xDC },
    { 0x4C,0x07 },
    { 0x4D,0x08 },
    { 0x51,0x02 },
    { 0x52,0xBC },
    { 0x53,0x02 },
    { 0x54,0xBC },
    { 0x55,0x07 },
    { 0x56,0x08 },
    { 0x57,0x07 },
    { 0x58,0x08 },
    { 0x59,0x08 },
    { 0x5A,0x08 },
    
    { 0x7F,0x02 }, // Bank2, not allowed to perform SPIWriteRead
    { 0x07,0x1B },
    { 0x08,0x1F },
    { 0x09,0x23 },
    { 0x51,0x01 },
    
    { 0x7F,0x03 }, // Bank3, not allowed to perform SPIWriteRead
    { 0x07,0x07 },
    { 0x08,0x06 },
    { 0x2F,0x00 },
    { 0x30,0x20 },
    { 0x32,0x59 },
    { 0x33,0xD8 },
    { 0x34,0x4E },
    { 0x35,0x20 },
    { 0x36,0x5B },
    { 0x37,0xCC },
    { 0x38,0x50 },
    { 0x39,0x14 },
    
    { 0x7F,0x04 }, // Bank4, not allowed to perform SPIWriteRead
    { 0x05,0x01 },
    { 0x2C,0x06 },
    { 0x2E,0x0C },
    { 0x30,0x0C },
    { 0x32,0x06 },
    { 0x34,0x03 },
    { 0x38,0x17 },
    { 0x39,0x71 },
    { 0x3A,0x18 },
    { 0x3B,0x4D },
    { 0x3C,0x18 },
    { 0x3D,0x4D },
    { 0x3E,0x14 },
    { 0x3F,0xD1 },
    { 0x40,0x14 },
    { 0x41,0xDD },
    { 0x42,0x0A },
    { 0x43,0x6C },
    { 0x44,0x08 },
    { 0x45,0xAD },
    { 0x46,0x06 },
    { 0x47,0xF2 },
    { 0x48,0x06 },
    { 0x49,0xEC },
    { 0x4A,0x06 },
    { 0x4B,0xEC },
    { 0x53,0x08 },
    
    { 0x7F,0x05 }, // Bank5, not allowed to perform SPIWriteRead
    { 0x03,0x00 },
    { 0x09,0x01 },
    { 0x0B,0xFF },
    { 0x0D,0xFF },
    { 0x0F,0xFF },
    { 0x11,0xFF },
    { 0x12,0xD2 },
    { 0x13,0xD2 },
    { 0x19,0xFF },
    { 0x1B,0xFF },
    { 0x1D,0xFF },
    { 0x1F,0xFF },
    { 0x20,0xD2 },
    { 0x21,0xD2 },
    { 0x2F,0x7C },
    { 0x30,0x05 },
    { 0x41,0x02 },
    { 0x53,0xFF },
    { 0x5F,0x02 },
    
    { 0x7F,0x06 }, // Bank6, not allowed to perform SPIWriteRead
    { 0x2A,0x05 }, // Write ONLY address, not allowed to perform SPIWriteRead
    { 0x35,0x19 },
    
    { 0x7F,0x07 }, // Bank7, not allowed to perform SPIWriteRead
    { 0x00,0x01 },
    { 0x14,0x03 },
    { 0x15,0x14 },
    { 0x46,0x03 },
    
    { 0x7F,0x00 }, // Bank0, not allowed to perform SPIWriteRead
};
#define initialize_size (sizeof(initialize)/sizeof(initialize[0]))



const uint8_t modeLaser[][2] = {
    { 0x7F, 0x00 }, // Bank0, not allowed to perform SPIWriteRead
    { 0x09, 0x5A }, // disable write protect
    { 0x53, 0x01 },
    { 0x07, 0xCC },
    { 0x0D, 0x05 },
    { 0x0E, 0x05 },
    { 0x19, 0x24 },
    { 0x7F, 0x01 }, // Bank1, not allowed to perform SPIWriteRead
    { 0x1D, 0x18 },
    { 0x1F, 0x12 },
    { 0x42, 0x40 },
    { 0x37, 0x60 },
    { 0x43, 0x0A },
    { 0x7F, 0x04 }, // Bank4, not allowed to perform SPIWriteRead
    { 0x06, 0x03 },
    { 0x7F, 0x05 }, // Bank5, not allowed to perform SPIWriteRead
    { 0x2E, 0x02 },
    { 0x48, 0x00 },
    { 0x3E, 0x05 },
    { 0x7F, 0x06 }, // Bank6, not allowed to perform SPIWriteRead
    { 0x34, 0x01 },
    { 0x7F, 0x00 }, // Bank0, not allowed to perform SPIWriteRead
    { 0x09, 0x00 }, // enable write protect
};
#define modeLaser_size (sizeof(modeLaser)/sizeof(modeLaser[0]))



const uint8_t modeLED[][2] = {
    { 0x7F, 0x00 }, // Bank0, not allowed to perform SPIWriteRead
    { 0x09, 0x5A }, // disable write protect
    { 0x07, 0x55 },
    { 0x0D, 0x7D },
    { 0x0E, 0x7D },
    { 0x19, 0x3C },
    { 0x7F, 0x01 }, // Bank1, not allowed to perform SPIWriteRead
    { 0x1D, 0x00 },
    { 0x1F, 0x00 },
    { 0x42, 0x20 },
    { 0x37, 0x18 },
    { 0x43, 0x02 },
    { 0x7F, 0x04 }, // Bank4, not allowed to perform SPIWriteRead
    { 0x06, 0x00 },
    { 0x7F, 0x05 }, // Bank5, not allowed to perform SPIWriteRead
    { 0x2E, 0x08 },
    { 0x48, 0x02 },
    { 0x3E, 0x85 },
    { 0x7F, 0x06 }, // Bank6, not allowed to perform SPIWriteRead
    { 0x34, 0x09 },
    { 0x7F, 0x00 }, // Bank0, not allowed to perform SPIWriteRead
    { 0x53, 0x00 },
    { 0x09, 0x00 }, // enable write protect
};
#define modeLED_size (sizeof(modeLED)/sizeof(modeLED[0]))
