// PAA5101 Optical Tracking Minuature Chip reference code.
// Version: 1.0
// Latest Revision Date: 29 Jan. 2018
// By PixArt Imaging Inc.
// Primary Engineer: Vincent Yeh (PixArt USA)

/*
//=======================
//Revision History
//=======================
Version 1.1 -- Fixed SPI frequency from 10MHz to 2MHz.
Version 1.0 -- First release.
*/

#include "mbed.h"
#include "registerArrays.h"
#include "SPIcommFunctions.h"

int main()
{
    pc.baud(115200);                    // Set baud rate to 115200. Remember to sync serial terminal baud rate to the same value.

    spi.format(8,3);                    // Set SPI to 8 bits with inverted polarity and phase-shifted to second edge.
    spi.frequency(2000000);            // Set frequency for SPI communication.
    cs = 1;                             // Initialize chip-select pin to be HIGH (inactive).
    
    pc.printf("Program START\n\r");
    
    writeRegister(0x7F, 0x00);          //Reset to bank 0 before initializing again
    
    pc.printf("ID Check: %2X\n\r", readRegister(0x00)); //Checks product ID to make sure communication protocol is working properly.
    if(readRegister(0x00) != 0x31)
    {
        pc.printf("Communication protocol error! Terminating program.\n\r");
        return 0;
    }
    
    writeRegister(0x06, 0x80);          //Resets the chip now that we have verified that the communication works.
    wait_ms(1);                         //Wait at least 1 millisecond after resetting for timing.
    
    pc.printf("ID Check #2: %2X\n\r", readRegister(0x00)); //Checks product ID to make sure communication protocol is working properly after the reset.
    if(readRegister(0x00) != 0x31)
    {
        pc.printf("Communication protocol error! Terminating program.\n\r");
        return 0;
    }
    
    writeRegister(0x09, 0x5A);          //Disables write-protect
    writeRegister(0x51, 0x06);          //Sets laser diode power. Value should be <= 6
    
    load(initialize, initialize_size);  //Loads initial register settings
    
    writeRegister(0x5D, 0x3E);          //Unlisted register. Internal recommendation...
    wait_ms(10);
    writeRegister(0x5D, 0x3F);          //Unlisted register. Internal recommendation...

    load(modeLaser, modeLaser_size);    //Goes into laser mode which is the default mode (not LED)
    mode = 0;                           //This variable tracks if we are in laser mode or LED mode. 0 = laser, 1 = LED
    LDP = 0;                            //Change GPIO pin to the laser diode to be LOW to activate the laser.
    
    writeRegister(0x09, 0x00);          //Enables write-protect
    
    
    
    while(1)                            //After all setup/initialization is done, we can loop for interrupts and mode detection.
    {   
        checkMode();                    //Checks image quality and switches to laser or LED mode accordingly.
        
        if(readRegister(0x02) & 0x80)   //If motion bit (bit 7 of register 0x02) is 1, movement has been detected.
        {
            grabData();                 //Grabs data into variables deltaX and deltaY.
            printData();                //Prints deltaX and deltaY, but only if they have changed from their previous values.
        }
    }
}
