#include "mbed.h"
#include "motor.h"
#include <ros.h>
#include <std_msgs/Float64.h>
#include <std_msgs/Int32.h>
#include <std_msgs/String.h>
#include <geometry_msgs/Point.h>



BusOut bus(D11,D12);
MotorCtl motor1(D3,bus,D4,D5);
InterruptIn tachoINT1(D4);
InterruptIn tachoINT2(D5);
RawSerial pc(USBTX,USBRX,115200);

char rx_buffer[10];
int index=0;
volatile int flag;
void update_current(void)
{
    motor1.UpdateCurrentPosition();
    //  pc.printf("Update Position\r\n");
}
void rx_cb(void)
{
    char ch;
    ch = pc.getc();
    pc.putc(ch);
    rx_buffer[index++]=ch;
    if(ch==0x0D) {
        pc.putc(0x0A);
        rx_buffer[--index]='\0';
        index=0;
        flag=1;
    }
}

void set_speed(void)
{
    int speed;
    speed = atoi((const char*)rx_buffer);

    motor1.setTarget(speed);

   pc.printf(" Set speed = %d\r\n", speed);

}

int main()
{

    pc.attach(callback(rx_cb));
    int rpm;
    tachoINT1.fall(&update_current);
    tachoINT1.rise(&update_current);
    tachoINT2.fall(&update_current);
    tachoINT2.rise(&update_current);

//    char flaw_curr_state[10] = "stable";
    wait(1);
    motor1.setTarget(60);
    
    while(1) {
        flag=0;

        pc.printf("Enter the value for speed [-78,78]\r\n");
        while(flag!=1){
            rpm = motor1.getRPM();
//            pc.printf("RPM: %d\r\n",rpm);
            wait(1);
        }
//        motor1.setTarget(60);
        set_speed();
    }

}