#ifndef __UTILITY__
#define __UTILITY__

// Headers inclusion
#include "stdio.h"
#include "mbed.h"
#include "math.h"
#include "string"
#include "string.h"
#include "Rtc_Ds1307.h"

// Some macros
extern RawSerial pc_io;
#define LOG(...) pc_io.printf(__VA_ARGS__)
#define M_PI  3.14159265358979323846  /* pi */
#define REFRESH_PERIOD 1  // (s)
#define FETCH_PERIOD 3600
#define RANGE_THRESHOLD 15.0 // (inches)
#define CHANGE_SCREEN_TIME 1
#define CHANGE_SET_ALARM_TIME 3

// THe pin macros
#define ALARM_PIN PTD4
#define RTC_SDA PTC2
#define RTC_SCL PTC1
#define RANGE_AN PTB1
#define RANGE_CS PTA5

static const char *WEATHER_PLACE = "Oxford";
static const char *WIFI_SSID = "VM1688183";
static const char *WIFI_PASS = "brk3msjzKvCj";

class TimeClass {
    public:
        int hour;
        int minute;
        float second;
        TimeClass(int h, int m, float s);
        void inc(TimeClass *prev, float i);
};

enum weatherType {
    sunny, cloudy, rainy, snowy
};

class WeatherClass {
    public:
        weatherType type;
        int temp;
        bool isCelsius;
        char *place; 
        WeatherClass(weatherType, int, bool, char *);
};

class DateClass {
    public:
        int day;
        int month;
        int year;
        int dow;
        DateClass(int d, int m, int y, int dow);
};

class StateClass {
    public:
        TimeClass *time;
        TimeClass *prevTime;
        WeatherClass *weather;
        DateClass *date;
        TimeClass *alarm;
        int screenState;
        bool screenActive;
        bool duringAlarm;
        StateClass(TimeClass *t, TimeClass *p, WeatherClass *w, DateClass *d, TimeClass *a);
};

extern StateClass *programState;
void playAlarmSound();
bool getDistance();
void read_rtc(StateClass *ps);
void update_rtc(StateClass *ps);

#endif