#include "utility.h"


TimeClass::TimeClass (int h, int m, float s)
    :   hour(h), minute(m), second(s) {}

void TimeClass::inc(TimeClass *prev, float i) {
    prev->second = this->second;
    prev->minute = this->minute;
    prev->hour = this->hour;
    this->second += i;
    if (this->second >= 60) {
        this->second = 0;
        this->minute += 1;
    }
    
    if (this->minute == 60) {
        this->minute = 0;
        this->hour += 1;
    }
    
    if (this->hour == 24)
        this->hour = 0;
}

DateClass::DateClass(int d, int m, int y, int dow)
    :   day(d), month(m), year(y), dow(dow) {}
 
WeatherClass::WeatherClass(weatherType t, int tmp, bool cel, char *p)
    :   type(t), temp(tmp), isCelsius(cel), place(p) {}
 
StateClass::StateClass(TimeClass *t, TimeClass *p, WeatherClass *w, DateClass *d, TimeClass *a)
    :   time(t), prevTime(p), weather(w), date(d), alarm(a), screenState(0), screenActive(true), duringAlarm(false) {}


void playAlarmSound()
{
    PwmOut speaker(ALARM_PIN);      // alarm sound of regular beeps
    while (programState->duringAlarm) {
        speaker.period(1.0/150.0);  // 150hz period
        speaker =0.0125;
        wait(0.5);
        speaker=0.0;                // turn off audio
        wait(0.5);
    }
}

AnalogIn ain(RANGE_AN);
DigitalOut cs(RANGE_CS, 0);

bool getDistance()
{
    float adc, volts, inches;
    cs = 1;
    wait_us(30);
    adc = ain.read();           // read analog as a float
    volts = adc * 4.5;          // convert to volts
    inches = volts / 0.0095;
    cs = 0;
    return inches <= RANGE_THRESHOLD;
}

//I2C master(RTC_SDA, RTC_SCL);
Rtc_Ds1307 rtc(RTC_SDA, RTC_SCL);
void read_rtc(StateClass *ps)
{
    Rtc_Ds1307::Time_rtc data = {};
    int s = 0, m = 0, h = 0, dow = 0, d = 0, mo = 0, y = 0;
    //rtc.gettime(&s, &m, &h, &dow, &d, &mo, &y);
    rtc.getTime(data);
    h = data.hour;
    m = data.min;
    s = data.sec;
    dow = data.wday - 1;
    d = data.date;
    mo = data.mon;
    y = data.year;
    LOG("%d:%d:%d", h, m, s);
    //if (!rtc.isRunning())
    //    return;
    ps->time->hour = h;
    ps->prevTime->hour = h;
    ps->time->minute = m;
    ps->prevTime->minute = m;
    ps->time->second = s;
    ps->prevTime->second = s;
    ps->date->year = y;
    ps->date->day = d;
    ps->date->month = mo;
    ps->date->dow = dow-1;
}

void update_rtc(StateClass *ps)
{
    //DateTime data(ps->date->year, ps->date->month, ps->date->day, ps->time->hour, ps->time->minute, ps->time->second);
    //rtc.adjust(data);
}