#include "Wifi.h"

#define DEBUG

const int timer_timeout = 10000;
const int big_timeout = 60;

Wifi *thisWifi;

Wifi::Wifi(const char *s, const char *p)
 : esp(ESP_TX, ESP_RX), rst(ESP_RST), buf_pos(0), ssid(s), pass(p) {
    thisWifi = this;
}

bool Wifi::connect()
{
    rst = 0;
    wait(3);
    rst = 1;
    wait(3);
    LOG("Reset ESP\r\n");
    if (esp.connect(ssid, pass, NSAPI_SECURITY_WPA_WPA2) == 0) {
        LOG("YEAH, IP: %s\r\n", esp.get_ip_address());
        return true;
    }
    return false;
}

char *Wifi::getTimeDate()
{
    LOG("IN HERE\r\n");
    socket.open(&esp);
    LOG("Socket opened\r\n");
    socket.connect(TD_HOST, TD_PORT);
    LOG("Socket connected\r\n");
    socket.send("time\r\n", 6);
    char *data = (char *)calloc(23, 1);
    socket.recv(data, 22);
    LOG("Data: %s\r\n", data);
    socket.close();
    return data;
}