#include "utility.h"
#include "Display.h"
#include "Wifi.h"
#include "TSISensor.h"
#include "DS1307.h"



// Hardware abstractions
RawSerial pc_io(USBTX, USBRX, 115200);
Display screen;
Wifi wifi(WIFI_SSID, WIFI_PASS);
TSISensor tsi;
//InterruptIn set_a(SET_A_PIN);

bool wifi_con = false;
bool alarm_dup = false;
int set_alarm_state = 0;
int held_hand_time = 0;
bool dist_dup = false;

// The main program global states
StateClass *programState = NULL;
TimeClass *programTime = NULL;
TimeClass *programPrevTime = NULL;
TimeClass *programAlarm = NULL;
DateClass *programDate = NULL;
WeatherClass *programWeather = NULL;
Thread setAlarmThread;
Thread playAlarmThread;

// Timer Interrupt objects
Ticker clockTimer;
Ticker fetchTimer;
Ticker alarmTimer;

// Initialize the states and the hardware
void init_state_hw()
{
    //pc_io.baud(115200);
    /*if (wifi.connect()) {
        char *data = NULL;
        data = wifi.getTimeDate();
        wifi_con = true;
        LOG("Data: %s\r\n", data);
    } else
        LOG("NO");*/
    programTime = new TimeClass(11, 0, 0);
    programPrevTime = new TimeClass(11, 0, 0);
    programDate = new DateClass(26, 5, 2017, 5);
    programAlarm = new TimeClass(9, 0, -1);
    programWeather = new WeatherClass(sunny, 18, true, (char *)WEATHER_PLACE);
    //LOG("MOK");
    programState = new StateClass(programTime, programPrevTime, programWeather, programDate, programAlarm);
    programState->screenState = 0;
    programState->duringAlarm = true;
}

#define MIN_CAL 62.0
#define HOUR_CAL 12.0

void setAlarmTime()
{
    while (set_alarm_state != 0)
    {
        if (tsi.readPercentage()>0)
        {
            float tsp = tsi.readPercentage();
            if (set_alarm_state == 1)
                programAlarm->hour = programAlarm->hour < 12 ? tsp*HOUR_CAL : (12 + tsp*HOUR_CAL);
            else if (set_alarm_state == 2)
                programAlarm->minute = MIN_CAL*tsp;
            else if (set_alarm_state == 3)
                if (tsp > 0.5 && programAlarm->hour < 12)
                    programAlarm->hour += 12;
                else if (tsp < 0.5 && programAlarm->hour > 12)
                    programAlarm->hour -= 12;
        }
        programTime->hour = programAlarm->hour;
        programTime->minute = programAlarm->minute;
        programTime->second = programAlarm->second;
        screen.flashAlarmSet(programAlarm, set_alarm_state);
        wait(0.2);
    }
}

void serial_test()
{
    char c = pc_io.getc();
    pc_io.putc(c);
    if (c == 'x')
    {
         set_alarm_state = (set_alarm_state + 1)%4;
        if (set_alarm_state == 1) {
            set_alarm_state = 4;
        }
    }
}

void set_a_fnc()
{
    set_alarm_state = (set_alarm_state + 1)%4;
        if (set_alarm_state == 1) {
            set_alarm_state = 4;
        }
}

void refresh_and_inc()
{
    //led1 = !led1;
    //LOG("In Inc: %f\r\n", programTime->second);
    // Increment Time
    programTime->inc(programPrevTime, REFRESH_PERIOD);
    if (programState->screenState == 0)
        screen.drawClock(programTime, false, programPrevTime);
    else if (programState->screenState == 1)
        screen.drawClockBig(programTime, false, programPrevTime);
    
    if (programTime->hour == programAlarm->hour && programTime->minute == programAlarm->minute && programAlarm->second >= 0) {
        if (!alarm_dup) {
            alarm_dup = true;
            programState->duringAlarm = true;
            playAlarmThread.start(&playAlarmSound);
        }
    } else
        alarm_dup = false;
    
    if (getDistance()) {
        if (programState->duringAlarm)
            programState->duringAlarm = false;
        else {
            held_hand_time ++;
            /*if (!dist_dup && held_hand_time >= CHANGE_SET_ALARM_TIME) {
                dist_dup = true;
                set_alarm_state = (set_alarm_state + 1)%4;
                if (set_alarm_state == 1)
                    set_alarm_state = 4;
            }*/
        }
    } else {
        dist_dup = false;
        if (held_hand_time >= CHANGE_SCREEN_TIME && held_hand_time < CHANGE_SET_ALARM_TIME && set_alarm_state == 0) {
            set_alarm_state = 0;
            programState->screenState = 1 - programState->screenState;
            screen.drawAll(programState, true);
        }
        held_hand_time = 0;
    }
            
    //printf("HAH");
    //pc_io.printf("After Inc: %d\r\n", programTime->second);
    
    // Refresh Display
    /*if (programState->screenState == 0)
        screen.drawClock(programTime, false);
    else if (programState->screenState == 1)
        screen.drawClockBig(programTime, false);*/
    //screen.drawAll(programState);   
    //LOG ("OUT YEAH!\r\n");    
}

void fetch_data()
{
    LOG("Fetch happening\r\n");
    // NB Use the wifi module at some point
    if (!wifi_con)
        return;
    LOG ("GOT DATA!!!\r\n");
    char *data = NULL;
    data = wifi.getTimeDate();
    if (!data)
        return;
    int s, m, h, d, mo, y, dow, t;
    sscanf(data, "%d,%d,%d,%d,%d,%d,%d,%d", &s, &m, &h, &d, &mo, &y, &dow, &t);
    free(data);
    //led1 = 1;
    /*
    programWeather->type = cloudy;
    programWeather->temp = 10;
    programWeather->isCelsius = false;
    //programWeather->place = "London";
    if (programState->screenState == 0)
        screen.drawWeather(programWeather, false);
    */
    if (programWeather->temp != t) {
        programWeather->temp = t;
        screen.drawWeather(programWeather, false);
    }
    //led1 = 0;
    
    if (programDate->dow != dow || programDate->day != d || programDate->month != mo || programDate->year != y) {
        programDate->dow = dow;
        programDate->day = d;
        programDate->month = mo;
        programDate->year = y;
        if (programState->screenState == 0)
            screen.drawDate(programDate);
    } else {
        programDate->dow = dow;
        programDate->day = d;
        programDate->month = mo;
        programDate->year = y;
    }
    if (abs((programTime->hour)*3600+(programTime->minute)*60+(programTime->second)-h*3600-m*60-s) > 180) {
        programPrevTime->hour = programTime->hour;
        programPrevTime->minute = programTime->minute;
        programPrevTime->second = programTime->second;
        programTime->hour = h;
        programTime->minute = m;
        programTime->second = s;
        clockTimer.detach();
        clockTimer.attach(&refresh_and_inc, REFRESH_PERIOD);
        if (programState->screenState == 0)
            screen.drawClock(programTime, true, programPrevTime);
        else if (programState->screenState == 1)
            screen.drawClockBig(programTime, true, programPrevTime);
    }
        
    //screen.drawAll(programState, false);
    //LOG("Fetch happened\r\n");
}

void stopAlarm()
{
    programState->duringAlarm = false;
    alarmTimer.detach();
}

// main() runs in its own thread in the OS
int main() 
{
    init_state_hw();
    pc_io.attach(&serial_test);
    //update_rtc(programState);
    //read_rtc(programState);
    fetch_data();
    //set_a.rise(&set_a_fnc);
    //LOG("AFTER\r\n");
    //printf("OI OI");
    
    screen.drawAll(programState, true);
    
    //screen.drawDate(programDate);
    // Timer initializations
    
    clockTimer.attach(&refresh_and_inc, REFRESH_PERIOD);
    
    fetchTimer.attach(&fetch_data, FETCH_PERIOD);
    //alarmTimer.attach(&stopAlarm, 40);
    
    playAlarmSound();
    
    //LOG("YAY\r\n");
    // Infinite loop
    while (true) {
        if (set_alarm_state == 4) {
            set_alarm_state = 1;
            setAlarmThread.start(&setAlarmTime);
        }
            
    }
}
