#include "utility.h"
#include "ESP8266Interface.h"

#define BUFF_SIZE 100
#define ESP_TX PTE22
#define ESP_RX PTE23
#define ESP_RST PTC16
#define TD_HOST "67.205.147.133"
#define TD_PORT 5005

const int time_out = 30;


class Wifi
{
    public:
        ESP8266Interface esp;
        DigitalOut rst;
        char buf[BUFF_SIZE+1];
        int buf_pos;
        const char *ssid;
        const char *pass;
        TCPSocket socket;        

    public:
        Wifi(const char *s, const char *p);
        bool connect();
        char *getTimeDate();
    
};

typedef void(Wifi::*WifiMemFn)();
