#include "utility.h"
#include "SPI_TFT_ILI9341.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
//#include "font_big.h"

// The connection configuration for FRDM-KL25Z
#define DISPLAY_MOSI_PIN PTD6
#define DISPLAY_MISO_PIN PTD7
#define DISPLAY_SCLK_PIN PTD5
#define DISPLAY_CS_PIN PTD3
#define DISPLAY_RST_PIN PTA4
#define DISPLAY_DC_PIN PTA12 // dc is WR not

//graphics

class Display {
    private:
        SPI_TFT_ILI9341 myTFT;
        void drawImg(int x, int y, const unsigned char *img, int w, int h);
        void text(int x, int y, const char *str);
    public:
        Display ();
        void drawClock(TimeClass *time, bool comp, TimeClass *prevTime);
        void drawClockBig(TimeClass *time, bool comp, TimeClass *prevTime);
        void drawWeather(WeatherClass *data, bool draw_img);
        void drawAlarm(TimeClass *alarmTime);
        void drawDate(DateClass *date);
        void drawAll(StateClass *state, bool doCls);
        void flashAlarmSet(TimeClass *alarmTime, int set_alarm_state);
        void cls();
};