#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "Servo.h"
#include "Motor.h"

Servo launcher(p21); // Digital Out
Servo leftMotor(p22); // pwm
Servo rightMotor(p23); // pwm
DigitalOut solenoid(p9); //Solenoid output control bit

SDFileSystem sd(p11, p12, p13, p8, "sd"); // the pinout on the mbed Cool Components workshop board.
Serial bluetooth(p28,p27); // bluetooth control of the robot

Thread thread2; // thread for playing sound
Thread thread3; // thread for bluetooth messages
Mutex solenoidCtrl;
AnalogOut DACout(p18);
wave_player mySpeaker(&DACout);

int stopSound = 1;

void acceptMessage() {
    char buffer = 0;
    char bnum, bhit;
    while (1) {
        // Function to take in bluetooth messages and set global variables.
        if (bluetooth.readable()) {
         buffer = bluetooth.getc();
         if (buffer == '!') {
            buffer = bluetooth.getc();
            if(buffer == 'B') {
               // Check button
               bnum = bluetooth.getc(); //button number
               bhit = bluetooth.getc(); //1=hit, 0=release
               if (bluetooth.getc()==char(~('!' + 'B' + bnum + bhit))) { 
                    //checksum OK?
                    switch(bnum) {
                        case '1': {
                            if (bhit=='1') {
                                //turn on launcher motor.
                                launcher = 0.58;
                            }else{
                                //turn off launcher.
                                launcher = 0.5;
                            }
                            break;
                        }
                        case '2': {
                            if (bhit=='1') {
                                //enable sound.
                                stopSound = 0;
                                //let a ping pong ball through.
                                solenoidCtrl.lock();
                                solenoid = 1; //retract the solenoid
                                wait(0.05);
                                solenoid = 0; //extend the solenoid
                                solenoidCtrl.unlock();
                            }
                            break;
                        }
                        case '8': {
                            if (bhit=='1') {
                                //back
                                rightMotor = 0.0;
                                leftMotor = 0.0;
                            }else{
                                rightMotor = 0.5;
                                leftMotor = 0.5;
                            }
                            break;
                        }
                        case '7': {
                            if (bhit=='1') {
                                //forward
                                rightMotor = 1.0;
                                leftMotor = 1.0;
                            }else{
                                rightMotor = 0.5;
                                leftMotor = 0.5;
                            }
                            break;
                        }
                        case '6': {
                            if (bhit=='1') {
                                //turn right
                                rightMotor = 0.0;
                                leftMotor = 1.0;
                            }else{
                                rightMotor = 0.5;
                                leftMotor = 0.5;
                            }
                            break;
                        }
                        case '5': {
                            if (bhit=='1') {
                                //turn left
                                rightMotor = 1.0;
                                leftMotor = 0.0;
                            }else{
                                rightMotor = 0.5;
                                leftMotor = 0.5;
                            }
                            break;
                        }
                    }       
               }
            }
         }     
        }else{
            solenoidCtrl.lock();
            solenoid = 0; //extend the solenoid
            solenoidCtrl.unlock();   
        }
    }
}

void sound() {
    while (1)
    {
        // Start song and return once playing starts
        if (stopSound) {
            Thread::wait(100);
            continue;
        }
        FILE *wave_file;
        wave_file=fopen("/sd/wavfiles/boom.wav","r");
        mySpeaker.play(wave_file);
        fclose(wave_file);
        stopSound = 1;
        Thread::wait(500);
    }
 }
 
int main() {
    //Initialize motors and solenoid
    rightMotor = 0.5;
    leftMotor = 0.5;
    solenoid = 0;
    //Initialize ESC and turn off launcher
    launcher = 0.5;
    wait(5);
    launcher = 0.5;
    Thread::wait(2);
    thread2.start(sound);
    thread3.start(acceptMessage);
    while (true) {
        Thread::wait(500);
    }
}
