#include "mbed.h"
#include "C12832.h"

DigitalOut LED(D13);
DigitalIn BP(PC_13,PullNone);
AnalogIn pot1(PA_0);
Serial pc(SERIAL_TX, SERIAL_RX);
Ticker t;
Timer timer;

int cpt=48, inactif;
bool appui = false;

void isr_LED(void)
{
        if(cpt>57)
        {
            cpt=48;
            pc.putc(012);
        }
        if(appui)
        {
            pc.putc(cpt);
            LED=!LED; 
            cpt++;
        }       
}

int main()
{
    pc.baud(38400);
    t.attach(&isr_LED,0.25);   

    while(1) 
    {
     if(BP==0 && !appui)
     {
        appui=true;
        timer.reset();
        while(BP==0);
        timer.start();       
     }
      inactif = timer.read_ms();
      
        if(BP==0 && appui || inactif>10000)
     {
        appui=false;
        if(inactif>10000)
        {
            Timeout timer;
            t.attach(isr_LED,1);
        }
        timer.stop();
        inactif=0;
        cpt=48;
        while(BP==0);       
        pc.putc(012);
        
     }    
    }
}