#include "mbed.h"
#define MAXPOS 255
 
PwmOut myServoX(PB_3);
PwmOut myServoY(PB_6);
PwmOut myServoZ(PB_4);
 
 
int coord2pulse(float coord)
{
    if(0 <= coord <= MAXPOS)
        return int(coord*1000/150+750);// us
    return 750;
 
}
void draw(){
    myServoY.pulsewidth_us(750);
 }
void nodraw(){
    myServoY.pulsewidth_us(2000);
 }
 
void vertex2d(float x, float y){
 
    int pulseX = coord2pulse(x);
    int pulseY = coord2pulse(y);
    
    myServoX.pulsewidth_us(pulseX);
    myServoY.pulsewidth_us(pulseY);
 
}
void home()
{
vertex2d(0 ,0);
}    
 
void maxpos()
{
vertex2d(MAXPOS ,MAXPOS);
}    
 
int main() {
     // configuracion de  periodo
    myServoX.period_ms(20);
    myServoY.period_ms(20);
    myServoZ.period_ms(20);
    
    while(1)
    {
     draw();
     wait(3);
     home();
     wait(3);
     maxpos();    
     wait(3);
     nodraw();
     wait(3);
     
     }
 
}
 