/*******************************************************************************************
 *
 * University of York Robot Lab Pi Swarm Robot Library
 *
 * (C) Dr James Hilder, Dept. Electronics & Computer Science, University of York
 * 
 * Version 0.5  February 2014
 *
 * Designed for use with the Pi Swarm Board (enhanced MBED sensor board) v1.2
 *
 ******************************************************************************************/

#include "main.h"   // Certain parameters can be set by changing the defines in piswarm.h


PiSwarm piswarm;
Serial pc (USBTX,USBRX);

//This is where the program code goes.  In the simple demo, the outer LEDs are blinked.
int main() {
    init();
    
    int step = 0;
    
    while(1) {
        step ++;
        if(step==6)step=0;
        switch (step%3){
            case 0:  piswarm.set_oled_colour(50,0,0); break;
            case 1:  piswarm.set_oled_colour(0,50,0); break;
            case 2:  piswarm.set_oled_colour(0,0,50); break;
        }
        switch (step%2){
            case 0:  piswarm.set_oleds(1,0,1,0,1,0,1,0,1,0); break;
            case 1:  piswarm.set_oleds(0,1,0,1,0,1,0,1,0,1); break;
        }
        wait(0.25);
    }
}

/***************************************************************************************************************************************
 *
 * Beyond this point, the outline of several optional functions is given
 *
 * This may be left blank but should not be deleted
 *
 **************************************************************************************************************************************/
 

// Communications

// If using the communication stack (USE_COMMUNICATION_STACK = 1), functionality for handling user RF responses should be added to the following functions
// If the communication stack is not being used, all radio data is sent to processRawRFData() instead

void handleUserRFCommand(char sender, char broadcast_message, char request_response, char id, char is_command, char function, char * data, char length){
    // A 'user' RF Command has been received:  write the code here to process it
    // sender = ID of the sender, range 0 to 31
    // broadcast_message = 1 is message sent to all robots, 0 otherwise
    // request_response = 1 if a response is expected, 0 otherwise
    // id = Message ID, range 0 to 255
    // is_command = 1 is message is a command, 0 if it is a request.  If RF_ALLOW_COMMANDS is not selected, only requests will be sent to this block
    // function = The function identifier.  Range 0 to 15
    // * data = Array containing extra data bytes
    // length = Length of extra data bytes held (range 0 to 57)
    
}    

void handleUserRFResponse(char sender, char broadcast_message, char success, char id, char is_command, char function, char * data, char length){
    // A 'user' RF Response has been received:  write the code here to process it
    // sender = ID of the sender, range 0 to 31
    // broadcast_message = 1 is message sent to all robots, 0 otherwise
    // success = 1 if operation successful, 0 otherwise
    // id = Message ID, range 0 to 255
    // is_command = 1 is message is a command, 0 if it is a request.  If RF_ALLOW_COMMANDS is not selected, only requests will be sent to this block
    // function = The function identifier.  Range 0 to 15
    // * data = Array containing extra data bytes
    // length = Length of extra data bytes held (range 0 to 57)
  
}    

void processRawRFData(char * rstring, char cCount){
    // A raw RF packet has been received: write the code here to process it
    // rstring = The received packet
    // cCount = Packet length
}

void switch_pressed() {
    //Switch(es) pressed {1 = Center  2 = Right  4 = Left  8 = Down  16 = Up}
    char switches = piswarm.get_switches();
  
    //Do something...
}
