/*******************************************************************************
 * Copyright 2016, 2018 ARM Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

#ifndef PAL_MBEDOS_CONFIGURATION_H_

#include "cmsis_os.h"

#if (defined(MBED_DEBUG) && !defined(DEBUG))
    #define DEBUG
#endif

#ifndef PAL_RTOS_WAIT_FOREVER
    #define PAL_RTOS_WAIT_FOREVER osWaitForever
#endif

#ifndef PAL_NUMBER_OF_PARTITIONS
    #define PAL_NUMBER_OF_PARTITIONS 1
#endif


#ifndef PAL_FS_MOUNT_POINT_PRIMARY
    #if (PAL_NUMBER_OF_PARTITIONS == 2)
        #define PAL_FS_MOUNT_POINT_PRIMARY    "/sd"           //!< User should change this for the his working folder
    #else
        #define PAL_FS_MOUNT_POINT_PRIMARY    "/sd"
    #endif
#endif

#ifndef PAL_FS_MOUNT_POINT_SECONDARY
    #if (PAL_NUMBER_OF_PARTITIONS == 2)
        #define PAL_FS_MOUNT_POINT_SECONDARY    "/sd2"
    #else
        #define PAL_FS_MOUNT_POINT_SECONDARY    "/sd"         //!< User should change this for the his working folder
    #endif
#endif

#ifndef PAL_NUM_OF_THREAD_INSTANCES
    #define PAL_NUM_OF_THREAD_INSTANCES 1
#endif

#ifndef PAL_MAX_SEMAPHORE_COUNT
    #define PAL_MAX_SEMAPHORE_COUNT 1024
#endif

#define PAL_SKIP_TEST_MODULE_TLS
#define PAL_SKIP_TEST_MODULE_SOTP
#define PAL_SKIP_TEST_MODULE_RTOS
#define PAL_SKIP_TEST_MODULE_NETWORK
#define PAL_SKIP_TEST_MODULE_FILESYSTEM
#define PAL_SKIP_TEST_MODULE_UPDATE
#define PAL_SKIP_TEST_MODULE_INTERNALFLASH
#define PAL_DNS_API_VERSION 1

#endif /* PAL_MBEDOS_CONFIGURATION_H_ */
