#include "mbed.h"

DigitalOut green (D9);
DigitalOut yellow (D12);
DigitalOut red (D11);
DigitalOut blue (D10);

InterruptIn mybutton(USER_BUTTON);
enum statiPossibili { BLINK, SEQUENCE} macchinaAstati = BLINK;

void reset ()
{
    green = 1;
    red = 1;
    yellow = 0;
    blue = 0;
}

void off_on (int stato)
{
    green = stato;
    red = stato;
    yellow = stato;
    blue = stato;
}

void blink (float time, int rip)
{
    reset();
    green = !green;
    red = !red;
    yellow = !yellow;
    blue = !blue;
    wait (time);
}

void sequence (float time, int rip)
{
    off_on(0);
    green = !green;
    wait (time);
    red = !red;
    wait (time);
    yellow = !yellow;
    wait (time);
    blue = !blue;
    wait (time);
}
void pressed()
{
    switch(macchinaAstati) {
            case BLINK:
                macchinaAstati = SEQUENCE;
            break;
            
            case SEQUENCE:
                macchinaAstati = BLINK;
            break;
        }
}
 
int main()
{
    mybutton.fall(&pressed);
    while(1)
    {
        switch(macchinaAstati) {
            case BLINK:
                blink(0.1, 1);
            break;
            
            case SEQUENCE:
                sequence(0.1, 1);
            break;
        }
        wait(0.01);
    }
}