#include "dot_util.h"
#include "RadioEvent.h"
 

/////////////////////////////////////////////////////////////////////////////
// -------------------- DOT LIBRARY REQUIRED ------------------------------//
// * Because these example programs can be used for both mDot and xDot     //
//     devices, the LoRa stack is not included. The libmDot library should //
//     be imported if building for mDot devices. The libxDot library       //
//     should be imported if building for xDot devices.                    //
// * https://developer.mbed.org/teams/MultiTech/code/libmDot-dev-mbed5/    //
// * https://developer.mbed.org/teams/MultiTech/code/libmDot-mbed5/        //
// * https://developer.mbed.org/teams/MultiTech/code/libxDot-dev-mbed5/    //
// * https://developer.mbed.org/teams/MultiTech/code/libxDot-mbed5/        //
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////
// * these options must match the settings on your gateway //
// * edit their values to match your configuration         //
// * frequency sub band is only relevant for the 915 bands //
// * either the network name and passphrase can be used or //
//     the network ID (8 bytes) and KEY (16 bytes)         //
/////////////////////////////////////////////////////////////
static std::string network_name = "MultiTech";
static std::string network_passphrase = "MultiTech";
static uint8_t network_id[] = { 0x6C, 0x4E, 0xEF, 0x66, 0xF4, 0x79, 0x86, 0xA6 };
static uint8_t network_key[] = { 0x1F, 0x33, 0xA1, 0x70, 0xA5, 0xF1, 0xFD, 0xA0, 0xAB, 0x69, 0x7A, 0xAE, 0x2B, 0x95, 0x91, 0x6B };
static uint8_t frequency_sub_band = 1;
static lora::NetworkType network_type = lora::PUBLIC_LORAWAN;
static uint8_t join_delay = 5;
static uint8_t ack = 1;
static bool adr = true;

mDot* dot = NULL;
lora::ChannelPlan* plan = NULL;

Serial pc(USBTX, USBRX);

#if !defined(CHANNEL_PLAN)
#define CHANNEL_PLAN CP_AU915
#endif
int TIEMPO_Tx=30;
int TIEMPO_REINTENTOS_CONSECUTIVOS=10;
int cantidad_REINTENTOS=0;
int TIEMPO_RANDOM_SUP=60;
int TIEMPO_RANDOM_INF=20;

Ticker timer_payload;
Ticker timer_Reintento;
Ticker timer_random_rango;

int flag_payload=1;
int flag_Tx=0;
int flag_random_rango=0;

uint32_t Tiempo_reintento_join=10;   // en seg
uint32_t Tiempo_reintento_join_2=15; // en seg
/////***************DECLARACION DE FUNCIONES**********************////

void func_timer_payload(void);
void func_timer_Reintento(void);
void func_timer_random_rango(void);
/////***************DEFINICION DE FUNCIONES**********************////

void func_timer_payload(void)
{
    flag_payload=1;
}

void func_timer_Reintento(void)
{
    flag_Tx=1;
}
void func_timer_random_rango(void)
{
    flag_Tx=1;
}
//////////////////////////////////////////////////////////////////////

int main() {
    // Custom event handler for automatically displaying RX data
    RadioEvent events;
    //mDotEvent events;

    pc.baud(115200);

    mts::MTSLog::setLogLevel(mts::MTSLog::TRACE_LEVEL);

    plan = new lora::ChannelPlan_US915();
    MBED_ASSERT(plan);

    dot = mDot::getInstance(plan);
    MBED_ASSERT(dot);

    logInfo("mbed-os library version: %d.%d.%d", MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);

    // start from a well-known state
    logInfo("defaulting Dot configuration");
    dot->resetConfig();
    dot->resetNetworkSession();

        // make sure library logging is turned on
    dot->setLogLevel(mts::MTSLog::INFO_LEVEL);

    // attach the custom events handler
    dot->setEvents(&events);

    // update configuration if necessary
    if (dot->getJoinMode() != mDot::OTA) {
        logInfo("changing network join mode to OTA");
        if (dot->setJoinMode(mDot::OTA) != mDot::MDOT_OK) {
            logError("failed to set network join mode to OTA");
        }
    }
    // in OTA and AUTO_OTA join modes, the credentials can be passed to the library as a name and passphrase or an ID and KEY
    // only one method or the other should be used!
    // network ID = crc64(network name)
    // network KEY = cmac(network passphrase)
    //update_ota_config_name_phrase(network_name, network_passphrase, frequency_sub_band, network_type, ack);
    update_ota_config_id_key(network_id, network_key, frequency_sub_band, network_type, ack);

    dot->setLinkCheckThreshold(3);

    // configure the Dot for class C operation
    // the Dot must also be configured on the gateway for class C
    // use the lora-query application to do this on a Conduit: http://www.multitech.net/developer/software/lora/lora-network-server/
    // to provision your Dot for class C operation with a 3rd party gateway, see the gateway or network provider documentation
    logInfo("changing network mode to class C");
    if (dot->setClass("C") != mDot::MDOT_OK) {
        logError("failed to set network mode to class C");
    }

    // enable or disable Adaptive Data Rate
    dot->setAdr(adr);

    // Configure the join delay
    dot->setJoinDelay(join_delay);

    // save changes to configuration
    logInfo("saving configuration");
    if (!dot->saveConfig()) {
        logError("failed to save configuration");
    }

    // display configuration
    display_config();

    uint16_t valor=0;
    uint32_t Downlink_Counter=0;
    uint32_t Downlink_Counter_old=0;

    std::vector<uint8_t> tx_data;
    std::vector<uint8_t> rx_data;

    timer_payload.attach(&func_timer_payload, TIEMPO_Tx);

    
    int flag_error_envio=0;
    int num_intentos=0;
    int cantidad_envios= 1 + cantidad_REINTENTOS;
    int tiempo_rand=0;
    

    // join network if not joined
    if (!dot->getNetworkJoinStatus()) {
        //join_network(Tiempo_reintento_join);
        join_network(Tiempo_reintento_join);
    }

    while (true) {

        // join network if not joined
        if (!dot->getNetworkJoinStatus()) {
            // Elimito todos los timer para que no molesten, ademas no se van a usar hasta que no este enlazado otra vez
            // pense que molestaban para reenlazar pero no
            timer_payload.detach();

            //join_network(Tiempo_reintento_join_2);
            join_network(Tiempo_reintento_join_2);
            // Una vez enlazado voy a medir y transmitir y ya activo el timer
            flag_payload=1;
            timer_payload.attach(&func_timer_payload, TIEMPO_Tx);
        }
        
        if(flag_payload) // mediciones y armado de payload
        {          

            printf("\n\rarmando payload\n\r");
            
            tx_data.clear();
            //// El payload es un valor que se va incrementando
            valor++;
            tx_data.push_back((valor >> 8) & 0xFF);
            tx_data.push_back(valor & 0xFF);

            // Flags
            flag_payload=0;
            flag_Tx=1;
            flag_error_envio=0;
            num_intentos=0;
        }

        if(flag_Tx)
        {
            if(flag_error_envio==1)
            {
                timer_random_rango.detach();
                printf("\n\rElimino timer timer_random_rango\n\r");
                
            }
            

            // Envio
            logInfo("send valor: %d", valor);           

            if(((cantidad_envios - flag_error_envio - num_intentos) != 0) && send_data(tx_data)!=0) // si falla el envio y si todavia no se hicieron todos los reintentos
            {
                num_intentos++;
                if(num_intentos==1 && ((cantidad_envios - flag_error_envio - num_intentos) != 0))// si es la primera vez que entra al if y si num de reintentos es mayor a cero
                {
                    timer_Reintento.attach(&func_timer_Reintento, TIEMPO_REINTENTOS_CONSECUTIVOS);
                    printf("\n\rActivo timer timer_Tx\n\r");
                }
                    
                
            }
            else
            {   
                if(flag_error_envio==0 && (cantidad_envios - flag_error_envio - num_intentos) == 0)
                {
                    // Activo timer 3
                    // initialize random seed: 
                    srand (time(NULL));
                    
                    // Defino el intervalo del valor random y obtengo un valor
                    tiempo_rand = rand() % (TIEMPO_RANDOM_SUP-TIEMPO_RANDOM_INF) + TIEMPO_RANDOM_INF;
                    //logInfo("tiempo_rand = %d\n\r\n", tiempo_rand);
                    logInfo("tiempo_rand  = %d\n\r\n",tiempo_rand);

                    timer_random_rango.attach(&func_timer_random_rango, tiempo_rand);
                    printf("\n\rActivo timer timer_random_rango\n\r");

                    flag_error_envio=1;
                    num_intentos=0;

                }

                // elimino timer
                timer_Reintento.detach();
                printf("\n\rElimino timer timer_Tx\n\r");


                // Actualizo el contador 
                // en este caso siempre va a llegar un msj sea solo con el ACK o con un payload tambien
                Downlink_Counter=dot->getDownLinkCounter();
                Downlink_Counter_old=Downlink_Counter;
                
                // Recepcion Rx1
                // Leo el buffer si hay un payload
                // Hasta Payload de 200 Bytes recibe, maximo desconocido      
                if(dot->recv(rx_data)==dot->MDOT_OK)
                {
                    printf("longitud = %d", rx_data.size());

                    // Muestra todos los Bytes
                    printf("\n\rDato %d recibido:", Downlink_Counter);
                    for(int i=0;i<rx_data.size();i++)
                    {
                        printf("%02X ", rx_data[i]);
                    }
                    printf("\n\r");
                    
                    rx_data.clear();

                }
            }
                      
            flag_Tx=0;
        }

        // Recepcion Rx2
        // Si llego un msje
        if (Downlink_Counter_old!=(Downlink_Counter=dot->getDownLinkCounter()))
        {
             Downlink_Counter_old=Downlink_Counter;
            // Leo el buffer
            // MAX Payload 52 Bytes (Rx total 65 Bytes)
            if(dot->recv(rx_data)==dot->MDOT_OK)
            {
                printf("longitud = %d", rx_data.size());
                
                // Muestra todos los Bytes
                printf("\n\rDato %d recibido:", Downlink_Counter);
                for(int i=0;i<rx_data.size();i++)
                {
                    printf("%02X ", rx_data[i]);
                }
                printf("\n\r");            

                rx_data.clear();
            }          
        }
       
        
    }
 
    return 0;
}




