#include "GPS.h"

MODSERIAL pc(P0_2, P0_3); // tx, rx
MODSERIAL gps(P4_28, P4_29); // tx, rx

bool first = true;
bool firstTime = true;
bool filling = false;

double iniTime;

int32_t data[7];
int16_t miliseconds;
int32_t currentTime;

int fillIndex = 0;

const int MAX = 82;
char buffer[MAX];

int index = 0;

/* Relevant Data being Gathered
 *
 * INDEX    NAME             FORMAT      NMEA STRING
 * 0        Latitude         ddmm.mmmm   GGA
 * 1        Longitude        dddmm.mmmm  GGA
 * 2        GPS Quality      x           GGA
 * 3        Satellites Used  xx          GGA
 * 4        Altitude         x.x         GGA
 * 5        Course           x.x         VTG
 * 6        Speed in km/h    x.x         VTG
 */

void move(char* source, char* destination, char delim)
{
    int k = 0;
    for(;index < 10000; index++)
    {
        if(source[index] == delim)
        {
            break;
        }
        destination[k] = source[index];
        //pc.putc(source[index]);
        k++;
    }
    destination[k] = NULL;
}

void move(char* source, char* destination, int num)
{
    int k = 0;
    for(;index < index + num; index++)
    {
        destination[k] = source[index];
        k++;
    }
    destination[k] = NULL;
}



// Returns the first time value recorded as a double
double getInitialTime()
{
    return iniTime;
}

// Return the time (without miliseconds) relative to the initial time
int32_t getTime()
{
    return currentTime;
}

// Return just the miliseconds
int16_t getMiliseconds()
{
    return miliseconds;
}

// returns everything except the time
int32_t* getGPSData()
{
    int32_t * dataPointer = data;
    return dataPointer;
}

int32_t getLatitude()
{
    return data[0];
}

int32_t getLongitude()
{
    return data[1];
}

int32_t getGPSQuality()
{
    return data[2];
}

int32_t getSatellitesUsed()
{
    return data[3];
}

int32_t getAltitude()
{
    return data[4];
}

int32_t getCourse()
{
    return data[5];
}

int32_t getSpeed()
{
    return data[6];
}


void parse()
{
    double t, t2;
    index = 1;
    char dat[MAX + 1];
    move(buffer, dat, ',');
    index++;
    if(strcmp(dat, "GPGGA") == 0) // Is it the GGA string?
    {
        move(buffer, dat, ',');
        t = strtod(dat, NULL);
        if(firstTime)
        {
            firstTime = false;
            iniTime = t;
        }
        
        t = t - iniTime;
        t2 = floor(t);
        currentTime = t2;
        miliseconds = (int16_t)((t - t2) * 1000);
        
        
        index++;
        
        // latitude
        char temp[2];
        temp[0] = buffer[index];
        index++;
        temp[1] = buffer[index];
        index++;
        float total = 0;
        total = 60 * atof(temp);
        move(buffer, dat, ',');
        data[1] = (int32_t)((atof(dat)+total) * 10000);
        index += 2;
        if(buffer[index] == 'S')
        {
            data[1] *= -1;
        }
        
        index++;
        
        // longitude
        char temp2[3];
        temp2[0] = buffer[index];
        index++;
        temp2[1] = buffer[index];
        index++;
        temp2[2] = buffer[index];
        index++;
        
        total = 60 * atof(temp2);
        move(buffer, dat, ',');
        data[2] = (int32_t)((atof(dat)+total) * 10000);
        index += 2;
        if(buffer[index] == 'W')
        {
            data[1] *= -1;
        }
        index++;
        
        // quality
        move(buffer, dat, ',');        
        data[2] = atoi(dat);
        
        index++;
        
        // satellites
        move(buffer, dat, ',');
        data[3] = atoi(dat);
        
        index++;
        move(buffer, dat, ',');
                

        // altitude
        move(buffer, dat, ',');
        data[4] = (int32_t)(atof(dat) * 10);
    }
    else if(strcmp(dat, "GPVTG") == 0) // Is it VTG?
    {
        // course
        move(buffer, dat, ',');
        
        data[5] = (int32_t)(atof(dat) * 10);
        
        index++;
        for(int i = 0; i < 5; i++)
        {
            move(buffer, dat, ',');
            index++;
        }
        // speed (km/h)
        move(buffer, dat, ',');
        data[6] = (int32_t)(atof(dat) * 10);
        
    }
}

bool updateValues()
{   
    signed char c = gps.getcNb();
    
    while(c != -1)
    {
        if(!filling)
        {
            if(c == '$')
            {
                filling = true;
                buffer[0] = c;
                fillIndex = 1;
            }
        }
        else
        {
            if(c == '\n')
            {
                buffer[fillIndex] = c;
                fillIndex++;
                filling = false;
                parse();
            }
            else
            {
                buffer[fillIndex] = c;
                fillIndex++;
            }
        }
        c = gps.getcNb();
    }
    return true;
}