#ifndef INMACROS_H
#define INMACROS_H

/*************** Serial String Input ****************/

// Compare string to a word in the serial input, shorthand
#define CMP(w, string)      if (!strcasecmp(word[w-1], string))

// Macro linking a serial string to a change function, 2 word command
#define CHANGE_VAR(STR, NAME)                           \
CMP(1, STR) {                                           \
    float f = strtof(word[1], &next);                   \
    if (*next == 0) {                                   \
        if (param->change_##NAME(f)) {                  \
            op->profileModded=true;                     \
            parsed=true;                                \
        }                                               \
    }                                                   \
}

/*************** CAN Message Profile Out ***************/
#include "outMacros.h"

// Send out an item from the profile
#define CAN_PROFILE(DATA, ID)       \
SEND_CAN_SINGLE(param->DATA, ID);

// Replies for commands that do not return data
#define CAN_SUCCESS     \
msg.data[0]=1;          \
SEND_CAN(1, msg.id)     \
return 1;

#define CAN_FAIL        \
msg.data[0]=0;          \
SEND_CAN(1, msg.id)     \
return 0;

/*********************** CAN Bus Input ******************************/

template <class Type>
Type CAN_EXTRACT(Type type, CANMessage& msg) {
   return *((Type*)((void*)(&msg.data[0])));
}

#define CAN_CHANGE(NAME, ID)                                        \
if (msg.id == ID) {                                                 \
    if (msg.len == sizeof(param->NAME)) {                           \
        if (param->change_##NAME(CAN_EXTRACT(param->NAME, msg))) {  \
            op->profileModded=true;                                 \
            parsed = true;                                          \
        }                                                           \
    }                                                               \
    CAN_PROFILE(NAME, ID)                                           \
}


#endif
