#include "LatchMonitor.h"

LatchMonitor::LatchMonitor(PinName _ok, PinName _fault) : okPin(_ok, PullDown), faultPin(_fault, PullDown)
{
    started = false;
    startDelay = 0;
}

void LatchMonitor::setup(float* _startDelay)
{
    startDelay = _startDelay;
}

void LatchMonitor::delayStart()
{
    if (startDelay == 0) return;    // Not setup yet

    // Power-on reset detected
    if (LPC_SC->RSID & 1) {
        LPC_SC->RSID = 1;           // Clear POR flag
        started = false;            // Use the blocking startup timer
        startup.attach(this, &LatchMonitor::startupDelay, *startDelay);
    } else {
        started = true;             // Not a power-cycle, do not use the timer
    }
}

void LatchMonitor::startupDelay()
{
    started = true;
}
char LatchMonitor::update()
{
    char ret = 0;
    ret |= (!okPin << 0);       // Mirror the ok pin
    ret |= (faultPin << 1);     // Copy the fault pin

    if (started) {
        ret |= !okPin << 2;                 // Mirror the ok pin when started only
        if (!okPin && !faultPin) {          // If started && okFault but not caught in hardware
            //ret |= HARD_FAULT;
        }
    }
    return ret;
}
