#ifndef __LATCH_MONITOR_H
#define __LATCH_MONITOR_H

#include "mbed.h"

enum LatchMon_Status_Bits {
    OK_FAULT        = 1<<0,     // Device OK pin is low
    LATCHED_HARD    = 1<<1,     // Circuit is in the tripped state
    LATCHED_SOFT    = 1<<2,     // Software-timer has expired and decided to tag the fault
    HARD_FAULT      = 1<<3,     // The circuit should have latched open, but it did not
};

class LatchMonitor
{

public:
    // Make this startup delay longer than the actual hardware circuit delay so that it can catch errors in the circuit
    LatchMonitor(PinName _ok, PinName _fault);
    void setup(float* startDelay);
    void delayStart();
    
    char update();
private:
    float* startDelay;
    Timeout startup;
    void startupDelay();
    bool started;
    DigitalIn okPin;
    DigitalIn faultPin;
};

#endif