#ifndef _FILE_DC_DC_H
#define _FILE_DC_DC_H

#include "mbed.h"
#include "FanPump.h"

enum Channel_T {
    FAN1            = 0,
    FAN2            = 1,
    PUMP1           = 2,
    PUMP2           = 3,  
};

enum Status_Bits_T {  
    CONV_ON         = 1<<0,
    SET_ON          = 1<<1,
    POWER_UP        = 1<<2,
    POWER_DOWN      = 1<<3,
    OVER_CURRENT    = 1<<4,
    SENSOR_FAULT    = 1<<5,
};

class DC_DC{
public:
    DC_DC(PinName _dcdcPin, PinName _dcdcCurrent, PinName _fan1, PinName _fan2, PinName _pump1, PinName _pump2, float period, float slew, unsigned int size=50);
    void setup(float* onThreshold, float* overCurrent, float* startDelay, float* stopDelay);
    bool size(unsigned int size);
    float getCurrent() { return current; }
    void set(bool on); 
    void setPwm(enum Channel_T chan, float duty);
    float readPwm(enum Channel_T chan);
    /*
        char status =
        bit0 - 1 = DC-DC converter is actually on
        bit1 - 1 = DC-DC converter is set to on
        bit2 - 1 = DC-DC Startup, its use is currently blocked until ready
        bit3 - 1 = DC-DC Power-down, its use is currently blocked until ready
        bit4 - 1 = DC-DC over current (drawing more current than allowed according to sensor)
        bit5 - 1 = DC-DC current sensor out of range (broken)
    */
    char getStatus() { return status; }
    bool hasCritError() { return critError; }         // An error exists according to status above
    void sample();                   // Attach this function in a 10ms RTOS timer

private:
    
    Timer startTimer;
    Timer stopTimer;
    volatile bool isControlPinOn;
    DigitalOut dcdcControl;
    AnalogIn dcdcCurrent;
    
    float currentOffset;
    float* filterBuff;
    int buffTracker;
    unsigned int _size;
    
    void updateCurrent();
    volatile float current;
    volatile char status;
    volatile bool critError;
    
    FanPump fan1;
    FanPump fan2;
    FanPump pump1;
    FanPump pump2;
    
    float* onThreshold;
    float* overCurrent;
    float* startDelay;
    float* stopDelay;
};

#endif