#ifndef FREEZE_FRAME_H
#define FREEZE_FRAME_H

#include "OperatingInfo.h"
#include "Profile.h"

// Freeze frame class, containing everything that describes the current operation of the AMS
class FreezeFrame
{
public:
    FreezeFrame();
    Profile_checkSum param;              // Profile - contains parameters and configurable settings
    OperatingInfo_checkSum op;           // OperatingInfo - contains all the data gathered from sensors and processed outputs

    static bool getFrame(FreezeFrame **frame);  // Fetch pointer to the last stored freeze frame if available
    static bool writeFrame();                   // Write the current RAM frame to flash as a freeze frame
    static bool prepare();                      // Call on microcontroller startup, pre-erase a flash sector so flash write occurs very fast upon error

    static bool getError();     // Get last marked error state
    static bool setError();     // Mark error
    static bool clearError();   // Reset (clear) the freeze frame error flag
};

#endif
