#ifndef XBEE_MANAGER_H
#define XBEE_MANAGER_H

#include "mbed.h"
#include "CAN-xbee.h"

class XbeeManager {
public:
    XbeeManager(PinName tx1, PinName rx1, PinName tx2, PinName rx2, int baud, int txSize, int rxSize);
    void baud(int baudrate) {
        x1.baud(baudrate);
        x2.baud(baudrate);   
    }
    bool txSize(unsigned int size) {
        return (x1.txSize(size) && x2.txSize(size));   
    }
    bool rxSize(unsigned int size) {
        return (x1.rxSize(size) && x2.rxSize(size));          
    }
    
    bool send(CANMessage &msg);
    bool receive(CANMessage &msg); 
    unsigned int counterX1in;
    unsigned int counterX2in;
    unsigned int counterX1out;
    unsigned int counterX2out;
    unsigned int bytesX1out;
    unsigned int bytesX2out;
    
private:
    bool alternate;
    CANxbee x1;
    CANxbee x2;
    CANMessage extra;
    bool extraAvail;
};

#endif