#ifndef CAN_XBEE_H
#define CAN_XBEE_H

#include "mbed.h"
#include "MODSERIAL.h"

// The string format of a CAN message shall be:
// char0:       Letter 'C' - start of a CAN message
// char1:       message type = (extended?1:0 << 0) | (RTR?1:0 << 1) | (DLC << 2)
// char1:       ID lower byte
// char2:       ID upper byte
// char3-10:    data bytes (lowest first)
// lastChar:    \n - newline = end of message
//
// Extended ID message is the same but with more ID bytes.
// RTR messages show up as empty messages (no data, DLC=0) but are otherwise indistinguishable.

class CANxbee {
public:
    CANxbee(PinName tx, PinName rx, int baud, int txSize, int rxSize);
    
    bool send(CANMessage &msg, unsigned int* length);         // Send a CANMessage object over the xbee (first converts to serial)
    bool receive(CANMessage &msg);      // Receive a CANMessage object over the xbee (converts from serial message to CAN)
    void baud(int baudrate) {
        serial.baud(baudrate);   
    }
    bool txSize(unsigned int size) {
        return (serial.txBufferSetSize(size) == 0);   
    }
    bool rxSize(unsigned int size) {
        return (serial.rxBufferSetSize(size) == 0);   
    }   
private:
    MODSERIAL serial;
    char rxBuff[15];
    int rx_i;
    int getChars;
};

#endif