#ifndef CAN_RXIDS_H
#define CAN_RXIDS_H

#define RX_ID_BASE                      0x580                   // Start at 0x500 for this device

// Receive Command IDs
// NOTE after each command is parsed, a message will return back with the same ID of length 1 with data[0]=1 for success and data[0]=0 for fail
#define RESET_RX_ID                     RX_ID_BASE + 0x00       // Reset over CAN
#define RESETCLEAR_RX_ID                RX_ID_BASE + 0x01       // Clear all errors and then reset, clean slate startup
#define CLEAR_RX_ID                     RX_ID_BASE + 0x02       // Clear a freeze frame error (0), clear every fault (1)
#define TIME_RX_ID                      RX_ID_BASE + 0x03       // Change the time (MM DD YY HH MM SS - 6 bytes)
#define PROFILE_RX_ID                   RX_ID_BASE + 0x04       // Byte[0] = load/write Byte[1] = profile #

#define FAN_CONTROL_RX_ID               RX_ID_BASE + 0x10
#define PUMP_CONTROL_RX_ID              RX_ID_BASE + 0x11
#define SOC_RX_ID                       RX_ID_BASE + 0x12       // Change the current SOC to some float from 0 to 1
#define AH_RX_ID                        RX_ID_BASE + 0x13       // Change the current ampHours to some float from 0 to capacity

// Profile Data Change Requests
#define PROFILE_CHARGECURRENT_RX_ID     RX_ID_BASE + 0x20
#define PROFILE_DISCHARGECURRENT_RX_ID  RX_ID_BASE + 0x21
#define PROFILE_NOMINALCAPACITY_RX_ID   RX_ID_BASE + 0x22
#define PROFILE_GLVBATTAPS_RX_ID        RX_ID_BASE + 0x23
#define PROFILE_DCDCONTHRESHOLD_RX_ID   RX_ID_BASE + 0x24
#define PROFILE_DCDCOVERCURRENT_RX_ID   RX_ID_BASE + 0x25
#define PROFILE_DCDCSTARTDELAY_RX_ID    RX_ID_BASE + 0x26
#define PROFILE_DCDCSTOPDELAY_RX_ID     RX_ID_BASE + 0x27
#define PROFILE_DCDC_TAPS_RX_ID         RX_ID_BASE + 0x28
#define PROFILE_IMDSTARTDELAY_RX_ID     RX_ID_BASE + 0x29
#define PROFILE_AMSSTARTDELAY_RX_ID     RX_ID_BASE + 0x2A
#define PROFILE_INTERNALOVERTEMP_RX_ID  RX_ID_BASE + 0x2B
#define PROFILE_CANNOACK_RX_ID          RX_ID_BASE + 0x2C
#define PROFILE_EXTENDSERIAL_RX_ID      RX_ID_BASE + 0x2D
#define PROFILE_CANTXSIZE_RX_ID         RX_ID_BASE + 0x2E
#define PROFILE_CANRXSIZE_RX_ID         RX_ID_BASE + 0x2F
#define PROFILE_SERIALBAUD_RX_ID        RX_ID_BASE + 0x30
#define PROFILE_SERIALTXSIZE_RX_ID      RX_ID_BASE + 0x31

#define RX_ID_END                       0x5FF       // End of SYS MGMT receive block

// Messages from other devices in the car
#define CHARGER_ERR_RX_ID               0x700       // Is the charger connected?
#define AMS_MODE_RX_ID                  0x301       // Contains AIRs data
#define GLOBAL_CAR_RESET_RX_ID          0x602       // Reset button from steering wheel

#endif
