#ifndef OPERATING_INFO_H
#define OPERATING_INFO_H

#include "Constants.h"
#include <stdint.h>
#include <time.h>

enum OperatingMode {
    // MODES
    OKAY=1<<0,
    FAULT=1<<1,
};

// Items here will prevent moving from STANDBY to IDLE
enum TopLevelFaults {
    WATCHDOG            = 1<<0,     // Last reset caused by WDT
    BROWNOUT            = 1<<1,     // Last reset caused by Brownout
    CAN_FAULT           = 1<<2,     // CAN buffer overflow
    
    INT_OVER_TEMP       = 1<<3,     // Temp. sensor on Charge FET is over limit 
    IMD_LATCH           = 1<<4,     // Fault detected on the IMD latch circuit
    AMS_LATCH           = 1<<5,     // Fault detected on the AMS latch circuit
    IMD_FAULT           = 1<<6,     // IMD not okay or not running
    DCDC_FAULT          = 1<<7,
    GLVBAT_FAULT        = 1<<8,
    FREEZE_FRAME        = 1<<9,    // There is an error freeze frame captured, waiting to be inspected by user
};

enum SignalFlags {
    SHUTDOWN_CLOSED     = 1<<0,     // Shutdown circuit ready (closed)
    AIRS_CLOSED         = 1<<1,     // AIRs Closed (CAN)
    CHARGER_DET         = 1<<2,     // Charger detected (CAN)
};

// Contains all of the relevant operating data gathered from sensors and the prcoessed outputs
// NOTE there are no mutexes/protection mechanisms here!  Ensure single producer, single consumer for every item
class OperatingInfo
{
public:
     // Diagnostic data
    char mode;
    char signals;
    uint16_t faultCode;
    time_t SysTime;
    time_t startTime;
    signed char profileIndex;
    bool profileModded;
        
    struct {            // GLV-Battery related
        float current;
        float SOC;
        float Ah;
        float capacity;
        char error;
    } glvBat;
    
    struct {            // DC-DC converter and PWM channels
        char status;
        float current;
        struct {
            float pump1;
            float pump2;
            float fan1;
            float fan2;
        } request;
        struct {
            float pump1;
            float pump2;
            float fan1;
            float fan2;
        } actual;
    } dcdc;

    struct {                // IMD
        char status;
        float resistance;
        char error;
    } imd;
    
    struct {                // Latch circuit supervisor
        char imd;
        char ams;
    } latch;

    char switchState;
    float internalTemp;
};
class OperatingInfo_checkSum
{
public:
    OperatingInfo op;
    uint32_t BSDchecksum;
};
#endif
