#include "runTime.h"

void runTime::gather(void const* args)
{
    static int counter = 0;

    // POPULATE DATA
    op->SysTime             = time(0);      // Tick time

    // GLV Battery
    op->glvBat.current      = glvBat.current();
    op->glvBat.SOC          = glvBat.SOC();
    op->glvBat.Ah           = glvBat.ampHours();
    op->glvBat.capacity     = glvBat.capacity();
    op->glvBat.error        = glvBat.readError();

    // DC-DC converter & PWM channels
    op->dcdc.status         = dcdc.getStatus();
    op->dcdc.current        = dcdc.getCurrent();
    op->dcdc.actual.pump1   = dcdc.readPwm(PUMP1);
    op->dcdc.actual.pump2   = dcdc.readPwm(PUMP2);
    op->dcdc.actual.fan1    = dcdc.readPwm(FAN1);
    op->dcdc.actual.fan2    = dcdc.readPwm(FAN2);

    // IMD PWM
    op->imd.status          = imd.status();
    op->imd.resistance      = imd.resistance();
    static bool started=false;
    if (counter > 30) started=true;     // Give the IMD 3 seconds to turn on
    if (started) {
        op->imd.error       = ((op->imd.status != NORMAL) && (op->imd.status != SPEEDSTART)) || (isnan(op->imd.resistance));
    } else op->imd.error    = 0;
    
    // Reset latches
    op->latch.ams           = AMSlatch.update();
    op->latch.imd           = IMDlatch.update();

    // Switches
    op->switchState         = switches.poll();
    if (op->switchState == 0)   op->signals |= SHUTDOWN_CLOSED;
    else                        op->signals &= ~SHUTDOWN_CLOSED;

    // Temperaure
    op->internalTemp        = internalTmp.read();

    // Telemetry trackers
 //   op->xbee1.msgIn         = xbeeRelay.counterX1in;
 //   op->xbee1.msgOut        = xbeeRelay.counterX1out;
 //   op->xbee1.msgIn         = xbeeRelay.counterX2in;
 //   op->xbee2.msgOut        = xbeeRelay.counterX2out;
//    if (counter++ % 10 == 0) {                               // Do every 1 second
//        op->xbee1.rateOut   = xbeeRelay.bytesX1out / 1000.0;   // Measure data rate in KB/s
//        op->xbee2.rateOut   = xbeeRelay.bytesX2out / 1000.0;   
//        xbeeRelay.bytesX1out = 0;                            // Clear every second
 //       xbeeRelay.bytesX2out = 0;
 //   }
    
    // CATCH ERRORS
    if (op->glvBat.error)                                   op->faultCode |= GLVBAT_FAULT;
    if (op->dcdc.status & (OVER_CURRENT | SENSOR_FAULT))    op->faultCode |= DCDC_FAULT;
    if (op->internalTemp > param->internalOverTemp)         op->faultCode |= INT_OVER_TEMP;
    if (op->latch.ams & HARD_FAULT)                         op->faultCode |= AMS_LATCH;
    if (op->latch.imd & HARD_FAULT)                         op->faultCode |= IMD_LATCH;
    if (op->imd.error)                                      op->faultCode |= IMD_FAULT;
    
    if (FreezeFrame::getError())                          ;//  op->faultCode |= FREEZE_FRAME;
    else                                                    op->faultCode &= ~FREEZE_FRAME;
    
    // UPDATE MODE
    if (op->faultCode) op->mode = FAULT;
    else op->mode = OKAY;
    
    // ARREST ERROR
    if (op->mode == FAULT) {
        if (!FreezeFrame::getError()) {         // Write freeze frame is slot available
            if (FreezeFrame::writeFrame()) {
                op->faultCode |= FREEZE_FRAME;
            } 
        }   
    }

    // Update DC-DC converter
    if ((op->signals & SHUTDOWN_CLOSED) && (op->signals & AIRS_CLOSED) && !(op->signals & CHARGER_DET) && (op->mode == OKAY)) {
        dcdc.set(1);
    } else dcdc.set(0);

    // Update PWM channels
    dcdc.setPwm(PUMP1, op->dcdc.request.pump1);
    dcdc.setPwm(PUMP2, op->dcdc.request.pump2);
    dcdc.setPwm(FAN1,  op->dcdc.request.fan1);
    dcdc.setPwm(FAN2,  op->dcdc.request.fan2);
}
void runTime::clearFaults() {
    op->faultCode = 0;
    op->mode = OKAY;
    FreezeFrame::clearError();
}
void runTime::thread_sample(void const* args)
{
    glvBat.sample();    // Integrate next sample in GLV Battery coulomb counter
    dcdc.sample();      // Handle dc-dc filter and errors
    osSignalSet((osThreadId)(tempData.wdtThreadId), 1<<1);      // Signal watchdog thread
}