#ifndef OUT_MACROS_H
#define OUT_MACROS_H

/******************************* FOR WORKING WITH THE STRING BUFFER ***************************/


// Macros for working with the strings
#define ADD_SPRINTF_LINE    temp[max_charsPerLine-1]=0; padCenter(max_charsPerLine, temp, ' ');   // Cetner the string, then add newlines, and add to chunk
#define DIVIDER_LINE        padCenter(max_charsPerLine, "", 196);     // Generate a line full of divider char 196, add to chunk
#define TITLE(string)       padCenter(max_charsPerLine, string, 196); // Generate a title line (centered, surrounded by char 196), add to chunk
#define BLANK_LINE          padCenter(max_charsPerLine, "", ' ');     // Generate a line full of spaces (blank), add to chunk


/********************************** FOR WORKING WITH CAN MESSAGES ******************************/

#define SEND_CAN(LEN, ID)   \
msg.len = LEN;              \
msg.id = ID;                \
msg.type = CANData;         \
msg.format = CANStandard;   \
if (!can.txWrite(msg)) op->faultCode |= CAN_FAULT;

template <class Type>
void SEND_CAN_SINGLE(Type Data, int ID)
{
    CANMessage msg;
    *((Type*)((void*)&msg.data[0])) = Data;
    SEND_CAN(sizeof(Type), ID)
}
template <class Type>
void SEND_CAN_PAIR(Type Data1, Type Data2, int ID)
{
    CANMessage msg;
    *((Type*)((void*)&msg.data[0])) = Data1;
    *((Type*)((void*)&msg.data[sizeof(Type)])) = Data2;
    SEND_CAN(2*sizeof(Type), ID)
}

#define CAN_SINGLE(DATA, ID)         SEND_CAN_SINGLE(op->DATA, ID);
#define CAN_PAIR(DATA1, DATA2, ID)   SEND_CAN_PAIR(op->DATA1, op->DATA2, ID);

#endif
