#include "XbeeManager.h"

XbeeManager::XbeeManager(PinName tx1, PinName rx1, PinName tx2, PinName rx2, int baud, int txSize, int rxSize) :
                        x1(tx1, rx1, baud, txSize, rxSize), x2(tx2, rx2, baud, txSize, rxSize)
{
    alternate = false;
    extraAvail = false;
    counterX1in = 0;
    counterX2in = 0;
    counterX1out = 0;
    counterX2out = 0;
    bytesX1out = 0;
    bytesX2out = 0;
}

bool XbeeManager::send(CANMessage &msg)
{
    alternate = !alternate;
    unsigned int length;
    if (alternate) {
        if (x1.send(msg, &length)) {
            counterX1out++;
            bytesX1out += length;
            return true;   
        }
    } else {
        if (x2.send(msg, &length)) {
            counterX2out++;
            bytesX2out += length;
            return true;
        }
    }
    return false;
}

bool XbeeManager::receive(CANMessage &msg)
{
    if (extraAvail) {
        extraAvail = false;
        memcpy((void*)&msg, (void*)&extra, sizeof(CANMessage));
        counterX2in++;
        return true;
    }
    if (x1.receive(msg)) {
        if (x2.receive(extra)) {
            extraAvail = true;
        }
        counterX1in++;
        return true;
    } else {
        if (x2.receive(msg)) {
            counterX2in++;
            return true;   
        }
    }
    return false;
}