#ifndef __TEMPERATURE_H
#define __TEMPERATURE_H

#include "mbed.h"

typedef struct LOOKUP_TABLE_T {
    float *input;    
    float *output;
    int numEntries;
} LOOKUP_TABLE_T;

extern LOOKUP_TABLE_T NXFT15XH103_TABLE;

class Temperature {
public:
    Temperature(LOOKUP_TABLE_T *_table, PinName _pin);
    float readRaw();
    float read();
#ifdef MBED_OPERATORS
    operator float() {
        return read();
    }
#endif
private:
    float convert(float reading);
    LOOKUP_TABLE_T *table;
    AnalogIn pin;
};

#endif