#include "Temperature.h"

float NXFT15XH103_TABLE_IN[] = { 0.050512723, 0.056425741, 0.06305631, 0.07054559, 0.079189687, 0.088921283, 0.100071994, 0, 0.127018769, 0.143322197, 0.161706765, 0.182539034, 0.205908044, 0.232186732, 0.261393013, 0.293785311, 0.329354168, 0.368048534, 0.409646378, 0.453820525, 0.5, 0.547490837, 0.595469256, 0.642984648, 0.689103062, 0.732941648, 0.77373518, 0.810924767, 0.844154225, 0.873281379, 0.898354357, 0.919578592, 0.937262775, 0.951781202 };
float NXFT15XH103_TABLE_OUT[] = { 125, 120, 115, 110, 105, 100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 5, 0, -5, -10, -15, -20, -25, -30, -35, -40 };

LOOKUP_TABLE_T NXFT15XH103_TABLE = {
    NXFT15XH103_TABLE_IN,
    NXFT15XH103_TABLE_OUT,
    sizeof(NXFT15XH103_TABLE)/sizeof(float)
};

Temperature::Temperature(LOOKUP_TABLE_T *_table, PinName _pin) : pin(_pin) {
    table = _table;
}
float Temperature::convert(float reading) {
    float in = reading;
    if (in < table->input[0]) return INFINITY;                    // Out of range of the table
    if (in > table->input[table->numEntries-1]) return -INFINITY;    // Out of range of the table
    int lowerIndex = 0;
    int upperIndex = table->numEntries-1;
    for (int i = 0; i < table->numEntries; i++) {                  // Converge on the entries that surround the input
        if (in >= table->input[lowerIndex]) { lowerIndex = i; }
        if (in <= table->input[upperIndex]) { upperIndex = table->numEntries-1 - i; }
    }
    // Interpolate and return
    return table->output[lowerIndex] + (table->output[upperIndex] - table->output[lowerIndex]) * ((in - table->input[lowerIndex]) / (table->input[upperIndex] - table->input[lowerIndex]));
}
float Temperature::readRaw() {
    return pin.read();
}
float Temperature::read() {
    return convert(pin.read());
}