// copied idea from http://developer.mbed.org/forum/mbed/topic/466/?page=1#comment-2457

#ifndef _FILE_IMD_H
#define _FILE_IMD_H  

#include "mbed.h"

enum IMDstatus  {
    OFF         = 1<<0,
    NORMAL      = 1<<1,
    UNDERVOLT   = 1<<2,
    SPEEDSTART  = 1<<3,
    ERROR       = 1<<4,
    GROUNDERR   = 1<<5,
    INVALID     = 1<<6,  
};

class IMD{
public:
    IMD(PinName _pin);
    
    char status();
    // Gets the insulation resistance reading
    // Returns 0 to 50,000,000 in normal/UV modes
    // Returns 0 or 50,000,000 in speed start (good/bad only)
    // Nan for invalid measurement (out of permissible range)
    // Nan for not avail. in this mode
    float resistance();
    
    // Interrupt function for the edge type detected
    void edgeIRQ();
    // Used to zero (reset) the data on timeout
    void zeroIRQ();
    
private:
    float frequency();
    float duty();
    
    volatile uint32_t startTime;
    volatile uint32_t widthTicks;
    volatile uint32_t periodTicks;
    volatile bool first;
    
    LPC_TIM_TypeDef *timerBase;    // Base address of the active timer module
    int pin;                       // Capture pin#, 0 or 1
    int timer;
};

#endif