#ifndef _FILE_FANPUMP_H
#define _FILE_FANPUMP_H

#include "mbed.h"

class FanPump{
public:
    // Takes Pwmout pin, period (seconds), duty cycle slew rate in second^-1 (1 means duty 0 to 1 occurs over 1 second, 0 means no slew)
    // Use slew rate to implement soft start
    FanPump(PinName pin, float period, float slew);
    void write(float duty);
    float read();       // Read the last setpoint
    float readRaw();    // Read the raw current duty (may be mid-transition)
    void directOff();   // Turn off the channel immediately (no slew)
    #ifdef MBED_OPERATORS
    operator float() {
        return read();
    }
    FanPump& operator= (float value) {  // Overloaded equals to write function
        write(value);
        return *(this);
    }
    #endif
    int slew();         // Slew rate callback function
private:
    PwmOut pwm;         // mbed PWM out
    volatile uint32_t* MR_base;         // pwm channel# match register pointer
    volatile uint32_t  period_us;       // pwm period in us, shared by all channels
    volatile uint32_t  setPoint_us;     // pwm setpoint (goal) in us
    volatile uint32_t  maxChange_us;    // Max pulsewidth change in us allowed for each PWM period to achieve the slew rate
};

#endif
