#ifndef CAN_TXIDS_H
#define CAN_TXIDS_H

#define TX_ID_BASE              0x500                // Start at 0x500 for this device

// Transmit IDs - System Mgmt Specific
// Operating diagnostics
#define FAULTCODE_TX_ID         TX_ID_BASE + 0x00       // Error frame - critical errors that require shutdown
#define MODE_TX_ID              TX_ID_BASE + 0x01       // Operating mode
#define SIGNALS_TX_ID           TX_ID_BASE + 0x02       // Signals
#define PROFILE_TX_ID           TX_ID_BASE + 0x03       // Profile being used
#define TIME_TX_ID              TX_ID_BASE + 0x04       // SysTime and startup time

// GLV Battery
#define TEMP_TX_ID              TX_ID_BASE + 0x10       // Internal temperature of the glv battery chargerFET
#define GLV_CURRENT_TX_ID       TX_ID_BASE + 0x11       // GLV battery current
#define GLV_CAPACITY_TX_ID      TX_ID_BASE + 0x12       // GLV battery capacity setting
#define GLV_AH_TX_ID            TX_ID_BASE + 0x13       // GLV battery amphours
#define GLV_SOC_TX_ID           TX_ID_BASE + 0x14       // GLV battery SOC
#define GLV_ERROR_TX_ID         TX_ID_BASE + 0x15       // GLV battery error byte

// DC-DC Converter
#define DCDC_CURRENT_TX_ID      TX_ID_BASE + 0x20       // DC-DC current 
#define DCDC_STATUS_TX_ID       TX_ID_BASE + 0x21       // DC-DC status byte
#define PWM_FAN_TX_ID           TX_ID_BASE + 0x22       // FAN1 actual pwm
#define PWM_PUMP_TX_ID          TX_ID_BASE + 0x23       // PUMP1 actual pwm

// IMD
#define IMD_STATUS_TX_ID        TX_ID_BASE + 0x30       // IMD status byte
#define IMD_RESIST_TX_ID        TX_ID_BASE + 0x31       // IMD resistance measurement

// Latch Supervisor states
#define IMD_LATCH_TX_ID         TX_ID_BASE + 0x40       // IMD Latch circuit error byte
#define AMS_LATCH_TX_ID         TX_ID_BASE + 0x41       // AMS Latch circuit error byte

// Shutdown Switches
#define SWITCHES_TX_ID          TX_ID_BASE + 0x50       // Shutdown Switch State

#endif
