#ifndef CONSTANTS_H
#define CONSTATNS_H

#define NUM_STORED_PROFILES 3
#define CAN_DEVICE_TIMEOUT  0.2
#define SERIAL_BAUD     230400  // Serial port baud rate
#define CHAR_TIME       0.00005 // Time to send 1 char @ above baud
#define TX_SIZE         1000    // Serial buffer TX size
#define RX_SIZE         60      // Serial buffer RX size
#define CAN_TX_SIZE     128
#define CAN_RX_SIZE     64

#define XBEE_BAUD       250000  // 250k baud serial for xbees
#define XBEE_TX_SIZE    1000    // Serial buffer TX size for xbees
#define XBEE_RX_SIZE    100     // Serial buffer RX size for xbees

#define START_DELAY     10      // Startup delay for latch monitor circuits
#define FAST_LOOP       0.01    // Period (seconds) for fast loop (sampling, filters)
#define GATHER_LOOP     0.1     // Period (seconds) for main data processing loop
#define WDT_TIME        0.5     // Normal, running mode WDT timeout
#define CAN_LOOP        0.1     // Output period for CAN transmissions

#endif